"use client";
import { useRouter } from "next/navigation";

export default function Pagination({ page, limit, totaldata, basePath }) {
    const router = useRouter();
    const totalPages = Math.ceil(totaldata / limit);
    if (page > totalPages) {
        page = totalPages || 1; // fallback if no data
    }
    const handleLimitChange = (e) => {
        const newLimit = Number(e.target.value);
        router.push(`${basePath}?page=1&limit=${newLimit}`);
    };
    console.log({ page, limit, totaldata, totalPages }, " Pagination component");

    return (
        <div className="flex flex-col sm:flex-row items-center justify-between mt-6 space-y-3 sm:space-y-0 sm:space-x-4 px-4 py-3 bg-white ">
            {/* Left side - Page size selector */}
            <div className="flex items-center space-x-2">
                <label htmlFor="limit" className="text-sm text-gray-600">
                    Rows per page:
                </label>
                <select
                    id="limit"
                    value={limit}
                    onChange={handleLimitChange}
                    className="px-2 py-1 border rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-blue-500"
                >
                    {[5, 10, 20, 50, 100].map((size) => (
                        <option key={size} value={size}>
                            {size}
                        </option>
                    ))}
                </select>
            </div>

            {/* Right side - Pagination controls */}
            <div className="flex items-center space-x-3">
                <button
                    disabled={page <= 1}
                    onClick={() => router.push(`${basePath}?page=${page - 1}&limit=${limit}`)}
                    className={`px-4 py-2 rounded-lg border text-sm font-medium transition-colors
            ${page <= 1
                            ? "bg-gray-100 text-gray-400 border-gray-200 cursor-not-allowed"
                            : "bg-white text-gray-700 border-gray-300 hover:bg-blue-50 hover:text-blue-600"}
          `}
                >
                    Previous
                </button>

                <span className="px-3 text-gray-600 text-sm font-medium">
                    Page <span className="text-blue-600">{page}</span> of {totalPages}
                </span>

                <button
                    disabled={page >= totalPages}
                    onClick={() => router.push(`${basePath}?page=${page + 1}&limit=${limit}`)}
                    className={`px-4 py-2 rounded-lg border text-sm font-medium transition-colors
            ${page >= totalPages
                            ? "bg-gray-100 text-gray-400 border-gray-200 cursor-not-allowed"
                            : "bg-white text-gray-700 border-gray-300 hover:bg-blue-50 hover:text-blue-600"}
          `}
                >
                    Next
                </button>
            </div>
        </div>
    );
}
