'use client';

import { useRouter } from 'next/navigation';
import { FaDownload } from "react-icons/fa";

export const getCopyeditingColumns = () => [
    {
        label: 'S.No',
        name: 'S.No',
        cell: (_row, index) => index + 1,
    },
    {
        label: 'Book Title',
        name: 'Book Title',
        selector: (row) => row.book.book_title,
    },
    {
        label: 'Chapter Title',
        name: 'Chapter Title',
        selector: (row) => row.chap_title,
    },
    {
        label: "CE Status",
        name: "CE Status",
        selector: (row) => row.ce_editing[0].ce_status === 1 ? "Mail Send" : row.ce_editing[0].ce_status === 2 ? "Accepted" : row.ce_editing[0].ce_status === 3 ? "Uploaded" : row.ce_editing[0].ce_status === 4 ? "Rejected" : row.ce_editing[0].ce_status === 5 ? "TimeOut" : "-",
    },
    {
      label: "Editor Name",
      name: "Editor Name",
      selector: (row) => row.ce_editing[0].user.user_name,
    },
    {
        label: "Send Date",
        name: "Send Date",
        selector: (row) => row.ce_editing[0].ce_sent_date,
    }, 
    {
        label: "Due Date",
        name: "Due Date",
        selector: (row) => row.ce_editing[0].ce_due_date,
    }, 
    {
        label: "Send File",
        name: "Send File",
        cell: (row) => row.ce_editing[0].ce_sent_file ? ( <a  href={`/CE/Send_Files/${row.ce_editing[0].ce_sent_file}`} download target="_blank" title="Download File" > <FaDownload style={{ color: "#007bff", fontSize: "1.1rem" }} /> </a> ) : (  <span style={{ color: "gray" }}>No File</span> ),
    },
    {
        label: "Received Date",
        name: "Received Date",
        selector: (row) => {
            if (!row.ce_editing[0].ce_received_date) return "";
            const date = new Date(row.ce_editing[0].ce_received_date);
            return date.toISOString().split("T")[0];
        },
    },
    {
        label: "Received File",
        name: "Received File",
        cell: (row) => row.ce_editing[0].ce_received_file ? ( <a  href={`/CE/Recieve_Files/${row.ce_editing[0].ce_received_file}`} download target="_blank" title="Download File" > <FaDownload style={{ color: "#007bff", fontSize: "1.1rem" }} /> </a> ) : (  <span style={{ color: "gray" }}>No File</span> ),
    },
    // {
    //   label: "Comments",
    //   name: "Comments",
    //   selector: (row) => row.chapters[0].chap_comments,
    //   grow: 2,
    //   wrap: true,
    // },
];
