// components/dataTable/childDataTable.js
import { getBookWiseIdChapters } from '@/lib/services/bookService';
import { useEffect, useState, useMemo } from 'react';
import { toast } from 'react-toastify';

export default function ChildDataTable({ bookId }) {
    const [chapters, setChapters] = useState([]);
    const [loading, setLoading] = useState(true);

    useEffect(async () => {
        const fetchChapters = await getBookIdChapters(bookId);
        if (fetchChapters) {
            setChapters(fetchChapters);
            setLoading(false);
        }

    }, [bookId]);

    const columns = useMemo(() => [
        { label: 'Book Title', selector: (row) => row.book_title },
        { label: 'Manuscript ID', selector: (row) => row.chap_manuscriptID },
        { label: 'Chapter Title', selector: (row) => row.chap_title },
        { label: 'Author', selector: (row) => `${row.chap_firstName} ${row.chap_lastName}` },
        { label: 'Email', selector: (row) => row.chap_corresAuEmail },
        { label: 'Status', selector: (row) => row.chap_status },
        { label: 'P+ Status', selector: (row) => row.chap_pStatus },
        { label: 'Due Date', selector: (row) => row.chap_pdueDate },
        { label: 'Copy Editing', selector: (row) => row.chap_copyEditing },
        // Add other chapter-specific columns here
    ], []);

    if (loading) {
        return <div className="p-4 text-center">Loading chapters...</div>;
    }

    return (
        <div className="bg-white rounded-lg shadow-inner mt-4">
            <table className="min-w-full">
                <thead>
                    <tr className="bg-gray-50">
                        {columns.map((col, i) => (
                            <th key={i} className="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                {col.label}
                            </th>
                        ))}
                    </tr>
                </thead>
                <tbody>
                    {chapters.length > 0 ? chapters.map((row, rowIndex) => (
                        <tr key={rowIndex} className="even:bg-gray-50">
                            {columns.map((col, colIndex) => (
                                <td key={colIndex} className="px-6 py-4 whitespace-nowrap text-sm text-gray-800">
                                    {col.selector(row)}
                                </td>
                            ))}
                        </tr>
                    )) : (
                        <tr>
                            <td colSpan={columns.length} className="text-center py-4 text-gray-500">
                                No chapters found for this book.
                            </td>
                        </tr>
                    )}
                </tbody>
            </table>
        </div>
    );
}