import { getAllBooks } from "@/lib/services/bookService";
import Layout from "../../../components/copyedit-layout";
import CopyEditingList from "./CopyEditingList";
import { getAllChaptersByCE } from "@/lib/services/chapterService";

export const dynamic = "force-dynamic"; // ensure fresh DB read

export default async function CopyEditingPage() {
    const book = await getAllBooks();
    const bookIds = book.map(book => book.book_pid);
    const copyediting = await getAllChaptersByCE(bookIds);
  return (
    <Layout>
      <CopyEditingList 
        initialBooks={book}
        initialCopyediting={copyediting}
      />
    </Layout>
  );
}
