// app/books/create/page.jsx
// import Layout from "@/app/components/layout";
import CEActionForm from "././CEActionForm";
import { getServerSession } from 'next-auth';
import authOptions from "@/app/api/auth/[...nextauth]/authOptions"
export const dynamic = "force-dynamic"; // ensure fresh DB read
import Layout from "@/app/components/copyedit-layout";
import { encryptNumber,  decryptNumber } from "@/lib/encryption";
import { getCEDetailsById } from "@/lib/services/copyeditingService";


export default async function copyeditingAccept({ searchParams }) {

    const params = await searchParams;
    const encEditorDetailsPid = params.editor;
    let session = await getServerSession(authOptions);
    // const encryptedValue =  encryptNumber(2);
    // console.log(encryptedValue, "encryptedValue");

    console.log(encEditorDetailsPid, "encEditorDetailsPid from URL");

    const EditorDetailsPid =  decryptNumber(encEditorDetailsPid);
    console.log(EditorDetailsPid, "-----------Decryption Number");

    const ceEditiingDetails = await getCEDetailsById(EditorDetailsPid);

    console.log(ceEditiingDetails, "ceEditiingDetails in page.jsx");


    const CEData = {
        ceActionName: ceEditiingDetails?.user?.user_name || '*****', // Adjust property names as needed
        ceActionEmail: ceEditiingDetails?.user?.user_email || '*****',
        // Add any other necessary CE-specific data here
    };

    // --- Step 4: Temporarily inject CE data into the session object for this request
    // This does NOT permanently store it in the JWT/DB, but makes it available
    // to client components via useSession() during the initial render.
    // **NOTE:** This is the most straightforward way for server components.
    session = {
        ...session,
        CE: CEData, // This is the 'CE' object you check in your client component
    };

    
    
    // let book = null;
    
    // if (bookId) {
    //     book = await getBookById(Number(bookId));
    // }

    return (
        <Layout currentSession={session}>
            <CEActionForm
                ceEditiingDetails={ceEditiingDetails}
                // CEData={session?.CE}
            />
        </Layout>
    );
}