import Layout from "@/app/components/layout";
import ChaptersList from "./ChapterList";
import { getAllChapters, getAllManuScript } from '@/lib/services/chapterService';
import { getChapterEntryId } from '@/lib/services/entryService';
import { getServerSession } from 'next-auth';
import { getAllBooks , getAllBookYear} from '@/lib/services/bookService';
import authOptions from "@/app/api/auth/[...nextauth]/authOptions"
export const dynamic = "force-dynamic"; // ensure fresh DB read

export default async function ChaptersListPage() {
    const session = await getServerSession(authOptions);
    const user_role = session?.user.role;
    const chapters = await getAllChapters();
    const books = await getAllBooks();
    const book_year = await getAllBookYear();
    const chapter_manuScript = await getAllManuScript();

    const chapterEntriesPromises = chapters.map(async (chapter) => {
        const chapterId = chapter.chap_pid;
        const chapterEntries = await getChapterEntryId(chapterId);
        return chapterEntries;
    });

    const allChapterEntries = await Promise.all(chapterEntriesPromises);
    const flatChapterEntries = allChapterEntries.flat();
    return (
        <Layout>
            <ChaptersList
                initialChapters={chapters}
                initialChapterEntries={flatChapterEntries}
                initialChapterId={chapters.map(chapter => chapter.chap_pid)}
                role = {user_role}
                booklist = {books}
                bookyear = {book_year}
                manuscriptid = {chapter_manuScript}
            />
        </Layout>
    );
}