// columns.js
import { FiEdit, FiTrash2 } from "react-icons/fi";
import { Tooltip } from "react-tooltip";

export const getBookColumns = (router, handleDelete, combinedBook, role) => {
  const Role = Number(role);
  const columns = [
    {
      label: "S.No",
      name: "S.No",
      cell: (row, index) => index + 1,
    },
    {
      label: "Working Title",
      name: "Working Title",
      selector: (row) => row.book_year,
    },
    {
      label: "Book Title",
      name: "Book Title",
      selector: (row) => row.book_title,
    },
    {
      label: "Lead Editor Name",
      name: "Lead Editor Name",
      selector: (row) => row.book_LeadEditorName,
    },
    {
      label: "Book ID",
      name: "Book ID",
      cell: (row) => (
        <div
          className="flex items-center justify-center px-3 py-1 rounded-full bg-red-100 text-red-600 cursor-pointer hover:bg-red-200 hover:text-red-800 transition"
          onClick={() => router.push(`/booksIdByChapters/${row.book_pid}`)}
        >
          {row.book_CustomId}
        </div>
      ),
    },
    {
      label: "Online ISBN",
      name: "Online ISBN",
      selector: (row) => row.book_OnlineIsbn,
    },
    {
      label: "Author Invitations Sent Date",
      selector: (row) => row.book_AuthorInvitationsSent,
    },
    {
      label: "AU Invited",
      selector: (row) => row.book_AuInvited,
    },
    {
      label: "AU Accepted",
      selector: (row) => row.book_AuAccepted,
    },
    {
      label: "Chapter Due Date",
      selector: (row) => row.book_ChapDueDate,
    },
    {
      label: "Drop Dead Date",
      selector: (row) => row.book_DropDeadDate,
    },
    {
      label: "CH Submitted",
      selector: (row) => row.book_ChSubmitted,
    },
    {
      label: "CH Accepted",
      selector: (row) => row.book_ChAccepted,
    },
    {
      label: "Last Chapter Due to Production",
      selector: (row) => row.book_LastDueProduction,
    },
    {
      label: "Project Manager",
      //selector: (row) => row.book_ProjectManager,
      selector: (row) => row.pm_user?.user_name,
    },
    {
      label: "Note/Comments",
      selector: (row) => row.book_NoteComments,
    },
    {
      label: "Updated By",
      selector: (row) => row.user?.user_name || "",
    },
  ]

  if (Role !== 3) {
    columns.push(
      {
        label: "Action",
        cell: (row) => (
          <div className="flex space-x-3">
            <button
              onClick={() => router.push(`/books/create?id=${row.book_pid}`)}
              data-tooltip-id={`edit-tooltip-${row.book_pid}`}
              data-tooltip-content="Edit"
              className="text-blue-600 hover:text-blue-800 cursor-pointer"
              type="button"
            >
              <FiEdit size={20} />
              <Tooltip
                id={`edit-tooltip-${row.book_pid}`}
                place="top"
                style={{
                  backgroundColor: "#3b82f6",
                  color: "#fff",
                  fontSize: "12px",
                  borderRadius: "4px",
                  padding: "6px 10px",
                }}
              />
            </button>
            {combinedBook.some(entry => entry.id === row.book_pid && entry.value === 0) && (
              <button
                onClick={() => handleDelete(row.book_pid, row.book_CustomId)}
                data-tooltip-id={`delete-tooltip-${row.book_pid}`}
                data-tooltip-content="Delete"
                className="text-red-600 hover:text-red-800 cursor-pointer"
                type="button"
              >
                <FiTrash2 size={20} />
                <Tooltip
                  id={`delete-tooltip-${row.book_pid}`}
                  place="top"
                  style={{
                    backgroundColor: "#ef4444",
                    color: "#fff",
                    fontSize: "12px",
                    borderRadius: "4px",
                    padding: "6px 10px",
                  }}
                />
              </button>
            )}
          </div>
        ),
        ignoreRowClick: true,
      });
  }
  return columns;
}
