<!-- DataTables -->
<link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables/dataTables.bootstrap4.css"> 

<style type="text/css">
        body
            {
                counter-reset: Serial;           /* Set the Serial counter to 0 */
            }

            tr td:first-child:before
            {
              counter-increment: Serial;      /* Increment the Serial counter */
              content: counter(Serial); /* Display the counter */
            }
    </style>
  <!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Main content -->
    <section class="content">
      <!-- For Messages -->
      <?php $this->load->view('admin/includes/_messages.php') ?>
      <div class="card card-default">
        <div class="card-header">
          <div class="d-inline-block">
              <h3 class="card-title"> <i class="fa fa-list"></i>
              &nbsp; List of articles in issue : <strong><?php echo $this->uri->segment(4); ?></strong></h3>
          </div>
        </div>
        <div class="card-body table-responsive">
          <table  class="table table-bordered table-striped ">
          <thead>
          <tr>
          <th>S.NO.</th>
          <th>JOURNAL NAME</th>
          <th>ISSUE NAME</th>
          <th>ARTICLE NO.</th>
  		    <th>ORDER NO.</th>
  		    <th>PDF PAGES</th>
  		    <th>DOI NUMBER</th>
  		    <th>DELETE</th>          
          </tr>
          </thead>
          <tbody>
           
          </tbody>
          </table><br><br>
          <div class="row">
            <div class="col-md-5">
            <p style="text-align:right; font-weight:700;">First Page:</p>              
            </div>
            <div class="col-md-2"> 

                <input type="number" name="first_page" value="" class="form-control">             
            </div>
            <div class="col-md-3">
              <input type="submit" name="submit" value="Submit" class="btn btn-success">              
            </div>

          </div>
            </div>    
        </div>
      </div>
    <!-- /.box -->
  </section>  
</div>
<script type="text/javascript" language="javascript" >
$(document).ready(function(){
  
  function load_data()
  {
    $.ajax({
      url:"<?php echo base_url(); ?>admin/issues/load_data",
      dataType:"JSON",
      success:function(data){
        var html = '';
                
        for(var count = 0; count < data.length; count++)
        {
          html += '<tr>';
          html += '<td></td>';
          html += '<td class="table_data" data-row_id="'+data[count].id+'" data-column_name="journal_name" >CBM</td>';
          html += '<td class="table_data" data-row_id="'+data[count].id+'" data-column_name="issue_name" >'+data[count].issue_name+'</td>';
          html += '<td class="table_data" data-row_id="'+data[count].id+'" data-column_name="article_no" >'+data[count].article_no+'</td>';
          html += '<td class="table_data" data-row_id="'+data[count].id+'" data-column_name="order_by" contenteditable>'+data[count].order_by+'</td>';
          html += '<td class="table_data" data-row_id="'+data[count].id+'" data-column_name="pdf_pages" contenteditable>'+data[count].pdf_pages+'</td>';
          html += '<td class="table_data" data-row_id="'+data[count].id+'" data-column_name="doi_number" contenteditable>'+data[count].doi_number+'</td>';
          html += '<td><button type="button" name="delete_btn" id="'+data[count].id+'" class="btn btn-xs btn-danger btn_delete"><span class="fa fa-remove"></span></button></td></tr>';
        }
        $('tbody').html(html);
      }
    });
  }

  load_data();

  $(document).on('blur', '.table_data', function(){
    var id = $(this).data('row_id');
    var table_column = $(this).data('column_name');
    var value = $(this).text();
    $.ajax({
      url:"<?php echo base_url(); ?>admin/issues/update",
      method:"POST",
      data:{id:id, table_column:table_column, value:value},
      success:function(data)
      {
        load_data();
      }
    })
  });

  $(document).on('click', '.btn_delete', function(){
    var id = $(this).attr('id');
    if(confirm("Are you sure you want to delete this?"))
    {
      $.ajax({
        url:"<?php echo base_url(); ?>livetable/delete",
        method:"POST",
        data:{id:id},
        success:function(data){
          load_data();
        }
      })
    }
  });
  
});
</script>
<!-- DataTables -->
<script src="<?= base_url()?>assets/plugins/datatables/jquery.dataTables.js"></script>
<script src="<?= base_url()?>assets/plugins/datatables/dataTables.bootstrap4.js"></script>
<script>
  $(function () {
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": false,
      "autoWidth": true,
    });
  });
</script> 
<script>
  $("#invoices").addClass('active');
</script>
<style>
.removeRow
{
 background-color: #FF0000;
    color:#FFFFFF;
}
</style>

