<!-- DataTables -->
<link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables/dataTables.bootstrap4.css">
<style type="text/css">
body
{
	counter-reset: Serial;           /* Set the Serial counter to 0 */
}

tr td.serial:before
{
  counter-increment: Serial;      /* Increment the Serial counter */
  content: counter(Serial); /* Display the counter */
}
tr td.no_more_rows
{
	text-align:center;
	box-sizing: content-box;    
	border: 1px solid #dee2e6;
	padding: 0.75rem;
	vertical-align: top;
}
</style> 
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Main content -->
    <section class="content">
      <!-- For Messages -->
      <?php $this->load->view('admin/includes/_messages.php') ?>
      <div class="card card-default">
        <div class="card-header">
          <div class="d-inline-block">
              <h3 class="card-title"> <i class="fa fa-list"></i>
              &nbsp; List of Articles </h3>
          </div>
          <div class="d-inline-block float-right">
            <a href="<?= base_url('admin/articles/add'); ?>" class="btn btn-success"><i class="fa fa-plus"></i> &nbsp; Create Article </a>
          </div>
        </div>
        <div class="card-body table-responsive">
          <table id="example2" class="table table-bordered table-striped ">
          <thead>
          <tr>
            <th>S.NO.</th>
            <th>INCOMING DATE</th>
            <th>JOURNAL NAME</th>
  		      <th>ARTICLE NO.</th>
            <th>MS PAGES</th>
            <th>SUPPL.</th>
			 <th>NO. OF FIGURES</th>
            <th>NO. OF TABLES</th>
            <th>DUE&nbsp;DATE</th>
            <th>ARTICLE REMARKS</th>
            <th>SEND TO COPYEDITOR</th>
			<th>STAGE</th>
            <th>PRIORITY</th>
			<?php if($this->session->userdata('admin_role') == "Super Admin"){?>
            <th>ACTION</th>  
			<?php } ?>
          </tr>
          </thead>
          <tbody>
		  <?php if(count($article_detail) > 0) {?>
            <?php $s_no = 1; foreach($article_detail as $data): ?>
            <tr>
              <td class="serial"></td>
              <td><?= date('d-m-Y',strtotime($data['received_date'])); ?></td>
              <td><?= $data['journal_name']; ?></td>
              <td><?= $data['article_no']; ?></td>
              <td><?= $data['ms_word']; ?></td>
              <td><?= $data['supp']; ?></td>
			   <td><?= $data['nof']; ?></td>
              <td><?= $data['not1']; ?></td>
             
              <?php
              $today = date('Y-m-d');
              $due_date = date('d-m-Y',strtotime($data['due_date']));
              if ($data['due_date'] < $today) {
                ?><td style="background:red; color: white; font-weight: 700;"><?= $due_date; ?></td>
              <?php }
              else{ ?>
                <td><?= $due_date; ?></td>
              <?php
              }
              ?>
              
              <td><?= $data['remarks_article'] ?></td>
              <td>
                <?php
                  if ($data['sent_to_ce'] != '0000-00-00') { ?>
                    <a style="display:none;" href="#" class="btn-edit" data-id="<?= $data['id']?>" data-duedate="<?= $data['due_date']?>" data-status="<?= $data['status']?>" data-senttoce="<?= $data['sent_to_ce']?>"><strong><?= date('d-m-Y',strtotime($data['sent_to_ce']))?></strong></a>
					<strong><?= date('d-m-Y',strtotime($data['sent_to_ce']))?></strong>
                  <?php }
                  else{ ?>
                    <a href="#" class="btn-edit" data-id="<?= $data['id']?>" data-duedate="<?= $data['due_date']?>" data-status="<?= $data['status']?>" data-senttoce="<?= $data['sent_to_ce']?>"><strong>Send</strong></a>
                 <?php }
                ?>
                </td>
				<td><?= $data['current_stage'] ?></td>
				<?php 
				if($data['priority'] == 1)
				{
					$data['priority'] = 'High';
				}
				else
				{
					$data['priority'] = 'Regular';
				}
				
				?>
                <td><strong><?= $data['priority']?></strong>&nbsp;&nbsp;<a href="#" class="btn-edit1" data-id="<?= $data['id']?>"  data-priority="<?= $data['priority']?>">(Change)</a></td>
				
				<?php if($this->session->userdata('admin_role') == "Super Admin"){?>
				<td><div class="btn-group pull-right">
              
                <a href="<?= base_url('admin/articles/view/'.$data['id']); ?>" class="btn btn-info"><i class="fa fa-eye"></i></a>
                <a href="<?= base_url('admin/articles/edit/'.$data['id']); ?>" class="btn btn-warning" id="copyeditor"><i class="fa fa-edit"></i></a>
                <a href="<?= base_url('admin/articles/delete/'.$data['id']); ?>" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this item?');"><i class="fa fa-remove"></i></a>
            
              </div></td>
			  <?php } ?>
  		      </tr>
            <?php $s_no++; endforeach; ?>
		  <?php } else {?>
		  <tr><td colspan="14" style="text-align:center;">No data available in table</td></tr>
		  <?php } ?>
          </tbody>
          </table>
        </div>
      </div>
    <!-- /.box -->
  </section>  
</div>
<!-- Modal Send to Copyeditor-->
    <form action="updateSentToCe" method="post">
        <div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Send to Copyeditor</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
             
                <div class="form-group">
                    <label>Date</label>
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">

                    <input type="hidden" class="id" name="id" value="" >
                    <input type="hidden" class="" name="status" value="Copyediting" >
                    <input type="hidden" class="duedate" name="duedate" value="" >
                    <input type="date" class="form-control senttoce" name="senttoce" value="" >
                </div>             
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Update</button>
            </div>
            </div>
        </div>
        </div>
    </form>
    <!-- End Modal Priority-->
    <!-- Modal Send to Copyeditor-->
    <form action="articles/updatepriority" method="post">
        <div class="modal fade" id="editModal1" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Priority</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
             
                <div class="form-group">
                    <label>Priority</label>
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">

                    <input type="hidden" class="id" name="id" value="" >
					 
                    <!-- <input type="text" class="form-control priority" name="priority" value="" >-->
					<select class="form-control" name="priority">
					<option value="">Choose...</option>
					<option value="0">Regular</option>
					<option value="1">High</option>
					</select>
                </div>             
            </div>
            <div class="modal-footer">
                
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Update</button>
            </div>
            </div>
        </div>
        </div>
    </form>
    <!-- End Modal Priority-->

<!-- DataTables -->
<script src="<?= base_url()?>assets/plugins/datatables/jquery.dataTables.js"></script>
<script src="<?= base_url()?>assets/plugins/datatables/dataTables.bootstrap4.js"></script>

<script>
  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": true,
      "searching": true,
      "ordering": true,
      "info": true,
      "autoWidth": true
    });
  });
</script>
<script>
  $("#invoices").addClass('active');
</script>
<script>
  document.getElementById("copyeditor").onclick = function() {
    //disable
    this.disabled = true;

    //do some validation stuff
}
</script>

<script>
    $(document).ready(function(){
 
        // get Edit Send to CE
        $('.btn-edit').on('click',function(){
            // get data from button edit
            const id = $(this).data('id');
            const senttoce = $(this).data('senttoce');
            const status = $(this).data('status');
            const duedate = $(this).data('duedate');
            // Set data to Form Edit
            $('.id').val(id);
            $('.senttoce').val(senttoce);
            $('.status').val(status);
            $('.duedate').val(duedate);
            
            // Call Modal Edit
            $('#editModal').modal('show');
            
        });

        // get Edit Priority
        $('.btn-edit1').on('click',function(){
            // get data from button edit
            const id = $(this).data('id');
            const priority = $(this).data('priority');

            // Set data to Form Edit
            $('.id').val(id);
            $('.priority').val(priority);
        
            // Call Modal Edit
            $('#editModal1').modal('show');
            
        });
 
        // get Delete Product
        $('.btn-delete').on('click',function(){
            // get data from button edit
            const id = $(this).data('id');
            // Set data to Form Edit
            $('.productID').val(id);
            // Call Modal Edit
            $('#deleteModal').modal('show');
        });
         
    });
</script>