<!-- DataTables -->
<link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables/dataTables.bootstrap4.css"> 
<style type="text/css">
body
{
	counter-reset: Serial;           /* Set the Serial counter to 0 */
}

tr td.serial:before
{
  counter-increment: Serial;      /* Increment the Serial counter */
  content: counter(Serial); /* Display the counter */
}
tr td.no_more_rows
{
	text-align:center;
	box-sizing: content-box;    
	border: 1px solid #dee2e6;
	padding: 0.75rem;
	vertical-align: top;
}
</style>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Main content -->
    <section class="content">
      <!-- For Messages -->
      <?php $this->load->view('admin/includes/_messages.php') ?>
      <div class="card card-default">
        <div class="card-header">
          <div class="d-inline-block">
              <h3 class="card-title"> <i class="fa fa-list"></i>
              &nbsp; List of Articles in AOP Stage </h3>
          </div>
          
        <div class="card-body table-responsive">
          <table id="example2" class="table table-bordered table-striped ">
          <thead>
          <tr>
            <th>S.NO.</th>
            <th>JOURNAL NAME</th>
  		      <th>ARTICLE NO.</th>
            <th>PDF PAGES</th>
            <th>APPROVED DATE</th>
            <th>EXPECTED UPLOAD DATE</th>
            <th>UPLOADED DATE</th>
            <th>STATUS</th>
            <th>PRODUCTION REMARKS</th>
          </tr>
          </thead>
          <tbody>
		   <?php if(count($article_detail) > 0) {?>
            <?php $s_no = 1;foreach($article_detail as $data): ?>
            <tr>
              <td class="serial"></td>
              <td><?= $data['journal_name']; ?></td>
              <td><a href="<?= base_url('admin/articles/view/'.$data['id']); ?>"><?= $data['article_no']; ?></a></td>
              <td><?= $data['pdf_pages']; ?></td>
              <td><?= date('d-m-Y',strtotime($data['approved_date'])); ?></td>
               <?php
              $today = date('Y-m-d');
              $due_date = date('d-m-Y',strtotime($data['exp_upload']));
              if ($data['exp_upload'] < $today) {
                ?><td style="background:red; color: white; font-weight: 700;"><?= $due_date; ?></td>
              <?php }
              else{ ?>
                <td><?= $due_date; ?></td>
              <?php
              }
              ?>  
              <td><?php
                  if ($data['uploaded_date'] != '0000-00-00') { ?>
                    <a href="#" class="btn-edit" data-id="<?= $data['id']?>" data-duedate="<?= $data['due_date']?>" data-status="<?= $data['status']?>" data-senttoce="<?= $data['uploaded_date']?>"><strong><?= date('d-m-Y',strtotime($data['uploaded_date']))?></strong></a>
                  <?php }
                  else{ ?>
                    <a href="#" class="btn-edit" data-id="<?= $data['id']?>" data-duedate="<?= $data['due_date']?>" data-status="<?= $data['status']?>" data-senttoce="<?= $data['uploaded_date']?>"><strong>Send</strong></a>
                 <?php }
                ?></td>
              <td><?= $data['status']; ?></td>
              <td style="text-align:center;"><a href="#" class="btn-remarks" data-id="<?= $data['id']?>" data-remarks_article="<?= $data['remarks_article']?>" data-remarks_ce="<?= $data['remarks_ce']?>" data-remarks_author="<?= $data['remarks_author']?>" data-remarks_typesetting="<?= $data['remarks_typesetting']?>" data-remarks_pe="<?= $data['remarks_pe']?>" data-remarks_production="<?= $data['remarks_production']?>">
					<i class="fa fa-comments" aria-hidden="true" style="font-size:30px;"></i>
					</a></td>
              
  		      </tr>
            <?php $s_no++; endforeach; ?>
			 <?php } else {?>
		  <tr><td colspan="9" class="no_more_rows">No data available in table</td></tr>
		  <?php } ?>
          </tbody>
          </table>
        </div>
		<p style="text-align:center;padding-top:2%;"><button type="button" class="btn btn-success" onclick="window.history.back()" >Back</button></p>
      </div>
    <!-- /.box -->
  </section>  
</div>
<!-- Modal Edit Product-->
    <form action="updateuploaded" method="post">
        <div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Uploaded Date</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
             
                <div class="form-group">
                    <label>Date</label>
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">

                    <input type="hidden" class="id" name="id" value="" >
                    <input type="hidden" class="" name="status">
                    <input type="hidden" class="duedate" name="duedate" value="" >
                    <input type="date" class="form-control uploaded" name="uploaded" value="" required >
                </div>             
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Update</button>
            </div>
            </div>
        </div>
        </div>
    </form>
    <!-- End Modal Edit Product-->

<!-- Remarks Start -->
	
	<div class="modal fade" id="all_remarks" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Remarks</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
                    <input type="hidden" class="id" name="id" value="" >
                </div> 
			<div class="form-group">
                    <label style="width:100%;padding-right:5%;">Fresh Article</label>
                    <input style="width:100%;" type="text" class="remarks_article" value="">
                </div> 
			<div class="form-group">
                    <label style="width:100%;padding-right:5%;">Copyediting</label>
                    <input style="width:100%;" type="text" class="remarks_ce" value="">
                </div> 
			<div class="form-group">
                    <label style="width:100%;padding-right:5%;">CE Proof - Author</label>
                    <input style="width:100%;" type="text" class="remarks_author" value="">
                </div>  
			<div class="form-group">
                    <label style="width:100%;padding-right:5%;">Typesetting</label>
                    <input style="width:100%;" type="text" class="remarks_typesetting" value="">
                </div>
			<div class="form-group" style="display:none;">
                    <label style="width:100%;padding-right:5%;">Production Editor</label>
                    <input style="width:100%;" type="text" class="remarks_pe" value="">
                </div>	
			<div class="form-group" style="display:none;">
                    <label style="width:100%;padding-right:5%;">Production</label>
                    <input style="width:100%;" type="text" class="remarks_production" value="">
                </div>				
            </div>
            <div class="modal-footer">
                
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary" style="display:none;">Update</button>
            </div>
            </div>
        </div>
        </div>
<!-- Remarks End -->


<!-- DataTables -->
<script src="<?= base_url()?>assets/plugins/datatables/jquery.dataTables.js"></script>
<script src="<?= base_url()?>assets/plugins/datatables/dataTables.bootstrap4.js"></script>

<script>
  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": true,
      "searching": true,
      "ordering": true,
      "info": true,
      "autoWidth": true
    });
  });
</script>
<script>
  $("#invoices").addClass('active');
</script>
<script>
  document.getElementById("copyeditor").onclick = function() {
    //disable
    this.disabled = true;

    //do some validation stuff
}
</script>
<script src="/js/jquery.min.js"></script>
<script src="/js/bootstrap.bundle.min.js"></script>
<script>
// get Edit Product
$('.btn-edit').on('click',function(){
	// get data from button edit
	const id = $(this).data('id');
	const uploaded = $(this).data('uploaded');
	const status = $(this).data('status');
	const duedate = $(this).data('duedate');
	// Set data to Form Edit
	$('.id').val(id);
	$('.uploaded').val(uploaded);
	$('.status').val(status);
	$('.duedate').val(duedate);
	
	// Call Modal Edit
	$('#editModal').modal('show');
	
});

// get Delete Product
$('.btn-delete').on('click',function(){
	// get data from button edit
	const id = $(this).data('id');
	// Set data to Form Edit
	$('.productID').val(id);
	// Call Modal Edit
	$('#deleteModal').modal('show');
});

// get remarks model
$('.btn-remarks').on('click',function(){
	
	// get data from button edit
	const id = $(this).data('id');
	const remarks_article = $(this).data('remarks_article');
	const remarks_ce = $(this).data('remarks_ce');
	const remarks_author = $(this).data('remarks_author');
	const remarks_typesetting = $(this).data('remarks_typesetting');
	const remarks_pe = $(this).data('remarks_pe');
	const remarks_production = $(this).data('remarks_production');
	
	
	// Set data to Form Edit
	$('.id').val(id);
	$('.remarks_article').val(remarks_article);
	$('.remarks_ce').val(remarks_ce);
	$('.remarks_author').val(remarks_author);
	$('.remarks_typesetting').val(remarks_typesetting);
	$('.remarks_pe').val(remarks_pe);
	$('.remarks_production').val(remarks_production);
	
	
	// Call Modal Edit
	$('#all_remarks').modal('show');
	
});	
</script>