<?php defined('BASEPATH') OR exit('No direct script access allowed');

	class Issues extends MY_Controller {

		public function __construct(){

			parent::__construct();
			auth_check(); // check login auth
			$this->rbac->check_module_access();

			$this->load->model('admin/issues_model', 'issues_model');
			$this->load->model('admin/Activity_model', 'activity_model');
		}

		//---------------------------------------------------
		// // Get All Issues
		public function index(){

			$data['article_detail'] = $this->issues_model->get_all_published();

			$this->load->view('admin/includes/_header');
        	$this->load->view('admin/issues/issues-list', $data);
        	$this->load->view('admin/includes/_footer');
		}

		// //---------------------------------------------------
		// // Add New Issues
		public function add()
		{
		//	$this->rbac->check_operation_access(); // check opration permission

			if($this->input->post('submit')){
				
					$data['issue_data'] = array(

						'id' => "",
						'issue_name' => $this->input->post('issue_name'),
						'issue_id' => $this->input->post('issue_id'),
						'journal_name' => $this->input->post('journal_name'),
						'article_no' => $this->input->post('article_no'),
						'no_of_pages' => $this->input->post('no_of_pages'),
						'start_page' => $this->input->post('start_page'),
						'end_page' => $this->input->post('end_page'),
						'order_by' => $this->input->post('order_by'),
						'created_by' => $this->input->post('created_by'),
						'is_delete' => $this->input->post('is_delete'),
						'created_date' => $this->input->post('created_date'),
						
					);

					$issue_data = $this->security->xss_clean($data['issue_data']);

					$result = $this->issues_model->add_issue($issue_data);
					if($result){
						// Activity Log 
						$this->activity_model->add_log(7);

						$this->session->set_flashdata('success', 'Issue has been Added Successfully!');
						redirect(base_url('admin/issues'));
					}
				}	
			
			else{
				$data['title'] = 'Issues';
				$data['fms_create_issues'] = $this->issues_model->get_all_issues();

				$this->load->view('admin/includes/_header');
        		$this->load->view('admin/issues/add-issue', $data);
        		$this->load->view('admin/includes/_footer');
			}
			
		}

		//---------------------------------------------------
		// Get View Issue
		public function view($id=0){

		//	$this->rbac->check_operation_access(); // check opration permission

			$data['issue_detail'] = $this->issues_model->get_issue_by_id($id);

			$this->load->view('admin/includes/_header');
        	$this->load->view('admin/issues/issue-view', $data);
        	$this->load->view('admin/includes/_footer');
		}



		//---------------------------------------------------
		// Edit Invoice
		public function edit($id=0){

		//	$this->rbac->check_operation_access(); // check opration permission

			if($this->input->post('submit')){

					$data['issue_data'] = array(

						'id' => "",
						'issue_name' => $this->input->post('issue_name'),
						'issue_id' => $this->input->post('issue_id'),
						'journal_name' => $this->input->post('journal_name'),
						'article_no' => $this->input->post('article_no'),
						'no_of_pages' => $this->input->post('no_of_pages'),
						'start_page' => $this->input->post('start_page'),
						'end_page' => $this->input->post('end_page'),
						'order_by' => $this->input->post('order_by'),
						'created_by' => $this->input->post('created_by'),
						'is_delete' => $this->input->post('is_delete'),
						'created_date' => $this->input->post('created_date'),
					);

			$issue_data = $this->security->xss_clean($data['issue_data']);

					$result = $this->issues_model->update_issue($issue_data, $id);
					if($result){
						// Activity Log 
						$this->activity_model->add_log(7);

						$this->session->set_flashdata('success', 'Issue has been Added Successfully!');
						redirect(base_url('admin/Issues'));
					}
				}	
			
			else{
				$data['title'] = 'Issues';
				$data['issue_detail'] = $this->issues_model->get_issue_by_id($id);
				$data['fms_create_issues'] = $this->issues_model->get_all_Issues();

				$this->load->view('admin/includes/_header');
        		$this->load->view('admin/issues/edit-issue', $data);
        		$this->load->view('admin/includes/_footer');
			}
		}


		//---------------------------------------------------
		// Delete Issues
		public function delete($article_no){

		//	$this->rbac->check_operation_access(); // check opration permission

			$this->issues_model->updatearticle_status1($article_no);
			$result = $this->db->delete('fms_create_issues', array('article_no' => $article_no));
			if($result){
				// Activity Log 
				$this->activity_model->add_log(9);
				$this->session->set_flashdata('success', 'Record has been deleted Successfully!');
				$url = $_SERVER['HTTP_REFERER'];
					redirect($url);
			}
		}


		public function createissue()
		{
			if($this->input->post('submit'))
			{
				$data = array();
				$order_by = array_filter($this->input->post('order_by'));
				$article_no = $this->input->post('selected');
				
				if(!empty($article_no))
				{
					$status = "New";
					$stage = "Issue";
					$issue_name = "CBM_".$this->input->post('issue')."_".$this->input->post('volume');
					foreach(array_combine($article_no, $order_by) as $article_no => $order_by)			{					
						$get_article_doi_number = $this->issues_model->get_doi_number_model($article_no);
						if(count($get_article_doi_number) > 0)					
						{						
							$doi_number = $get_article_doi_number[0]['doi'];
						}					
						else					
						{						
							$doi_number = 0;
						}
						
						$data['issue_data'] = array(
							'article_no' => $article_no,
							'order_by' => $order_by,
							'issue' => $this->input->post('issue'),
							'volume' => $this->input->post('volume'),
							'issue_name' => $issue_name,
							'issue_year' => $this->input->post('issue_year'),
							'issue_month' => $this->input->post('issue_month'),
							'status' => $status,												
							'doi_number' => $doi_number,
						);
						$data1['article_detail'] = array(
							'current_stage' => $stage,
						);
						$issue_data = $this->security->xss_clean($data['issue_data']);
						$result = $this->issues_model->add_issue($issue_data);
						$article_detail = $this->security->xss_clean($data1['article_detail']);
						$result = $this->issues_model->updatearticle_status($article_detail, $article_no);
						$this->session->set_flashdata('msg',"Issue created Successfully!");
						$this->session->set_flashdata('msg_class','alert-success');
						$stage = "Issue";
					}
					
					redirect(base_url('admin/issues/issueprocessing'));
				}
				else
				{
					redirect(base_url('admin/issues'));
				}
			}
		}

		function addissue()
		 {
		  if($this->input->post('submit'))
		  {
		  	$article_no = $this->post('article_no');
		  	$order_by = $this->input->post('order_by');
		    $issue = $this->input->post('issue');
		    $volume = $this->input->post('volume');
		    $issue_year = $this->input->post('issue_year');
		    $issue_month = $this->input->post('issue_month');
		  	if ($article_no) {
		  		foreach($article_no as $data){
		  			$data['issue_data'] = array(
		  				'article_no' => $article_no[$i],
				       	'issue' => $issue,
				       	'volume' => $volume,
				       	'issue_year' => $issue_year,
				       	'issue_month' => $issue_month,
				       	'pdf_pages' => '0',
				       	'order_by' => $order_by,
				       	'doi_number' => '0',

		  			);
		  			$result = $this->issues_model->add_issue($issue_data);
		    $this->session->set_flashdata('msg',"Issue created Successfully!");
			$this->session->set_flashdata('msg_class','alert-success');
		  		
		  	}
		   }
		  }
		 }
		 public function issueprocessing(){

			$data['issue_detail'] = $this->issues_model->get_all_issue_processing();

			$this->load->view('admin/includes/_header');
        	$this->load->view('admin/issues/issues-processing', $data);
        	$this->load->view('admin/includes/_footer');
		}
		 public function issueinproduction(){

			$data['issue_detail'] = $this->issues_model->get_all_issue_production();

			$this->load->view('admin/includes/_header');
        	$this->load->view('admin/issues/issues-production', $data);
        	$this->load->view('admin/includes/_footer');
		}
		public function publishedissues(){

			$data['issue_detail'] = $this->issues_model->get_all_issue_published();

			$this->load->view('admin/includes/_header');
        	$this->load->view('admin/issues/issues-published', $data);
        	$this->load->view('admin/includes/_footer');
		}
		public function vieweachissue($issue_name){

		//	$this->rbac->check_operation_access(); // check opration permission
			$nameofissue = $issue_name;
			$data['issue_detail'] = $this->issues_model->get_issue_by_name($issue_name);

			$this->load->view('admin/includes/_header');
        	$this->load->view('admin/issues/view-issue', $data);
        	$this->load->view('admin/includes/_footer');
		}

		public function updatestatus()
	    {
	    //	$this->rbac->check_operation_access(); // check opration permission
	    	$model = new articles_model();
	        $id = $this->input->post('id');
	        $priority = $this->input->post('priority');
	        			
	        $data = array(
	            'priority'        => $this->input->post('priority'),
	        );
	        $model->update_data($data, $id);
	        redirect(base_url('admin/articles'));
		}

		public function updateSentToProd()
	    {
	    //	$this->rbac->check_operation_access(); // check opration permission
	    	$model = new issues_model();
	        $id = $this->input->post('id');
			$status = "Production";	

			$due_date = $this->input->post('senttoprod');
	        
	        $count3WD = 0;
			$temp = strtotime($due_date); 
			while($count3WD<3){
			    $next1WD = strtotime('+1 weekday', $temp);
			    $next1WDDate = date('Y-m-d', $next1WD);
			    if(!in_array($next1WDDate)){
			        $count3WD++;
			    }
			    $temp = $next1WD;
			}

			$new_due_date = date("Y-m-d", $temp);
		
	        $data = array(
	        	'issue_name' => $this->input->post('id'),
	            'sent_to_prod' => $this->input->post('senttoprod'),
	            'due_date' => $new_due_date,
	            'status' => $status,
	        );
	         $model->update_issue($data, $id);
	         $model->update_revises_data($data);


	         redirect(base_url('admin/issues/issueprocessing'));
		}
		public function updateRecFromProd()
	    {
	    //	$this->rbac->check_operation_access(); // check opration permission
	    	$model = new issues_model();
	        $id = $this->input->post('id');
			$status = "Production";	

			$due_date = $this->input->post('recfromprod');
	        
	        $count3WD = 0;
			$temp = strtotime($due_date); 
			while($count3WD<3){
			    $next1WD = strtotime('+1 weekday', $temp);
			    $next1WDDate = date('Y-m-d', $next1WD);
			    if(!in_array($next1WDDate)){
			        $count3WD++;
			    }
			    $temp = $next1WD;
			}

			$new_due_date = date("Y-m-d", $temp);
		
	        $data = array(
	        	'issue_name' => $this->input->post('id'),
	            'rec_from_prod' => $this->input->post('recfromprod'),
	            'due_date' => $new_due_date,
	            'status' => $status,
	        );
	         $model->update_issue($data, $id);
	         $model->update_revises_data($data);


	         redirect(base_url('admin/issues/issueinproduction'));
		}
		public function updatePublish()
	    {
	    //	$this->rbac->check_operation_access(); // check opration permission
	    	$model = new issues_model();
	        $id = $this->input->post('id');
			$status = "Published";	
		
	        $data = array(
	        	'issue_name' => $this->input->post('id'),
	            'published_date' => $this->input->post('publish'),
	            'status' => $status,
	        );
	         $model->update_issue($data, $id);
	         $model->update_revises_data($data);


	         redirect(base_url('admin/issues/issueinproduction'));
		}
		public function issuereviseslist($issue_name="0"){
		//	$this->rbac->check_operation_access(); // check opration permission
			$data['issue_detail'] = $this->issues_model->get_all_issuereviseslist($issue_name);

			$this->load->view('admin/includes/_header');
        	$this->load->view('admin/issues/issue-revises-list', $data);
        	$this->load->view('admin/includes/_footer');
		}

		public function updateOrder()
	    {
	    //	$this->rbac->check_operation_access(); // check opration permission
	    	$model = new articles_model();
	        $article_no = $this->input->post('article_no');
	        $order_by = $this->input->post('order_by');
	        			
	        $data = array(
	            'order_by'        => $this->input->post('order_by'),
	        );
	        $model->update_order($data, $article_no);
	        redirect(base_url('admin/issues/vieweachissue'));
		}




	public function viewissue(){

     $this->load->view('admin/issues/view-issue');
   }
   public function load_data()
	 {
	 	$issue_name = $this->uri->segment(4);
	 	$data = $this->db->query("select * from fms_create_issues where issue_name = '".$issue_name."'")->result();
	 	
		echo json_encode($data);



	 	// 
	  // $data['issue_detail'] = $this->issues_model->load_data($issue_name);
	  // echo json_encode($data);
	 }
   public function update()
	 {
	  $data = array(
	   $this->input->post('table_column') => $this->input->post('value')
	  );

	  $this->issues_model->update($data, $this->input->post('id'));
	 }
	

	public function updateissue()
		{

			if($this->input->post('submit'))
			{

				$id = $this->input->post('id');
				$article_no = $this->input->post('article_no');
				$order_by = $this->input->post('order_by');
				$pdf_pages = $this->input->post('pdf_pages');
				$doi_number = $this->input->post('doi_number');
				$first_page = $this->input->post('first_page');
			  
			  $data = array();
			  // foreach($article_no as $index => $value){
			  // 	$data = array(
			  // 		'article_no' => $article_no,
			  // 	);
			  // }
			  
			  foreach($id as $idx => $key){
					$data[$key] = array(
						'id' => $id[$idx],
						'article_no' => $article_no[$idx],
						'order_by' => $order_by[$idx],
						'pdf_pages' => $pdf_pages[$idx],
						'doi_number' => $doi_number[$idx],
						'first_page' => $first_page,
					);
			 }
			 	print_r($data);
			 	 $this->db->update_batch('fms_create_issues',$data, 'id');
			      $url = $_SERVER['HTTP_REFERER'];
					redirect($url);
			}
		}
 }
?>	