// services/stageMovementsService.js
import prisma from '@/lib/prismaconfig';


export const getAllStagesWithJoins = async (chapId) => {
  return await prisma.acs_stage_movements.findMany({
    include: {
      book: {
        select: {
          book_title: true,
        },
      },
      chapter: {
        select: {
          chap_title: true,
          chap_createdAt: true,
          chap_authorReviewCount: true,
        },
      },
      entry: {
        select: {
          entry_duration: true,    
        },
      },
        user: {
            select: {
                user_name: true,    
            },
        },

    },
    where: {
      stage_isdelete: "active", // 👈 filter out deleted chapter
      stage_chapId : Number(chapId)
    },
  });
};