import path from "path";
import fs from "fs";

// Helper function for atomic writing (if you use it)
export const writeFileSyncAtomic = (filePath, data) => {
    // A simplified atomic write for this context. 
    // In a production scenario, you might use a temp file and rename.
    fs.writeFileSync(filePath, data);
};

export const getUploadDir = () => {
  const uploadDir = path.join(process.cwd(), "public", "uploads");
  if (!fs.existsSync(uploadDir)) fs.mkdirSync(uploadDir, { recursive: true });
  return uploadDir;
};

export const getCompressedDir = () => {
  const compressedDir = path.join(process.cwd(), "public", "compressed");
  if (!fs.existsSync(compressedDir)) fs.mkdirSync(compressedDir, { recursive: true });
  return compressedDir;
};