// lib/actions/queryAction.js
'use server';

import { createQuery, updateQuery } from '@/lib/services/queryService';

export async function createQueryAction(payload) {
  try {
    console.log(payload, 'Payload in action');
    
    const chapters = await createQuery(payload);
    return {
      success: true,
      message: "Query Added Successfully",
      chapters
    };
  } catch (error) {
    console.error("Error creating Query details:", error);
    return {
      success: false,
      message: "Server error during Query details"
    };
  }
}

export async function updateQueriesAction(queries_pid ,payload) {
  try {
    console.log(payload, 'Payload in action Edit');
    
    const chapters = await updateQuery(queries_pid ,payload);
    return {
      success: true,
      message: "Query Updated Successfully",
      chapters
    };
  } catch (error) {
    console.error("Error updated Query details:", error);
    return {
      success: false,
      message: "Server error during Query details update"
    };
  }
}

export async function queryDeleteAction(queries_pid ,payload) {
  try {
    console.log(payload, 'Payload in action Delete');
    
    const queries = await updateQuery(queries_pid ,payload);
    return {
      success: true,
      message: "Query Updated Successfully",
      queries
    };
  } catch (error) {
    console.error("Error updated Query details:", error);
    return {
      success: false,
      message: "Server error during Query details update"
    };
  }
}

