// app/chapter/create/actions.js
'use server';

import { createChapter, updateChapter, getBookIdChapters } from '@/lib/services/chapterService';
import { encryptNumber,decryptNumber } from '../encryption';

export async function createChapterAction(payload) {
  try {
    const chapters = await createChapter(payload);
    return {
      success: true,
      message: "Chapter Created Successfully",
      chapters
    };
  } catch (error) {
    console.error("Error creating chapter details:", error);
    return {
      success: false,
      message: "Server error during chapter details"
    };
  }
}

export async function updateChapterAction(chapterId, payload) {
  try {
    const chapters = await updateChapter(chapterId, payload);
    return {
      success: true,
      message: "Chapter updated Successfully",
      chapters
    };
  } catch (error) {
    console.error("Error updateing chapter details:", error);
    return {
      success: false,
      message: "Server error during chapter details"
    };
  }
}

export async function GetChapterByIdAction(book_pid) {
  try {
    const chapters = await getBookIdChapters(book_pid);
    // console.log(chapters);
    return {
      success: true,
      message: "Chapter Details",
      chapters
    };
  } catch (error) {
    console.error("Error creating chapter details:", error);
    return {
      success: false,
      message: "Server error during chapter details"
    };
  }
}

export async function getEncryptChapterNumber(chapterId) {
  try {
    const chapters = await encryptNumber(chapterId);
    return {
      success: true,
      message: "Chapter Encrypt Data",
      chapters
    };
  } catch (error) {
    console.error("Error encrypt chapter data:", error);
    return {
      success: false,
      message: "Server error during encrypt chapter data"
    };
  }
}

export async function getDecryptChapterNumber(chapterId) {
  try {
    const decryptId = await decryptNumber(chapterId);
    return {
      success: true,
      message: "Chapter Decrypt Data",
      decryptId
    };
  } catch (error) {
    console.error("Error decrypt chapter data:", error);
    return {
      success: false,
      message: "Server error during decrypt chapter data"
    };
  }
}





