import cron from "node-cron";
import { processCeReassignments } from "../lib/services/ceReassignService.js";

if (!global.ceReassignJobStarted) {
  global.ceReassignJobStarted = true;

  cron.schedule(
    "59 23 * * *",
    async () => {
      console.log(
        "🕒 Running CE reassignment job:",
        new Date().toLocaleString("en-IN", { timeZone: "Asia/Kolkata" })
      );
      await processCeReassignments();
    },
    { timezone: "Asia/Kolkata" }
  );

  console.log("✅ CE reassignment cron initialized (every day 23:59:59 IST time run)");
} else {
  console.log("⚠️ CE reassignment cron already running — skipping duplicate init");
}
