"use client"
import React, { useState, useRef, useEffect } from 'react';
import { FaUser, FaSignOutAlt } from "react-icons/fa";
import Image from "next/image"
import { toast } from 'react-toastify';
import { signOut } from 'next-auth/react';
import { useSession } from "next-auth/react";
import { usePathname } from 'next/navigation';
export default function topmenubar( passedSession ) {
    
    const [showProfileMenu, setShowProfileMenu] = useState(false);
    const menuRef = useRef(null);
    let { data: session, status } = useSession();
    
    session = passedSession?.passedSession || session;
    const pathname = usePathname();
    // Close dropdown when clicking outside
    useEffect(() => {
        function handleClickOutside(event) {
        if (menuRef.current && !menuRef.current.contains(event.target)) {
            setShowProfileMenu(false);
        }
        }
        document.addEventListener('mousedown', handleClickOutside);
        return () => document.removeEventListener('mousedown', handleClickOutside);
    }, [status, session]);

    const handleLogout = async () => {
        try {
            fetch('/api/auth/logout', { method: 'POST' }).catch(console.error);
            toast.success('You have been logged out.');
            await signOut({ callbackUrl: '/' });
        } catch (error) {
            console.error("Logout error:", error);
            toast.error("An error occurred during logout.");
        }
    };
    
    // const user_name = session?.user?.name;
  // Conditional logic for user_name
    let user_name;
    // Check if the pathname starts with '/copyediting/accept'
    if (pathname && pathname.startsWith('/copyediting/accept')) {
        console.log("Inside copyediting/accept path++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",session);
        user_name = session?.CE?.ceActionName; // Use session?.CE?.name for this specific path
    } else {
        user_name = session?.user?.name; // Use session?.user?.name for all other paths
    }

    return (
        <header className="bg-gray-800 w-full h-16 flex items-center justify-between px-4 md:px-8  z-20 sticky top-0">
            <div className="flex items-center space-x-8">
                {/* Logo Area */}
                <div className="flex items-center flex-shrink-0">
                    <Image src={"/logo.png"} alt="Logo" width={120} height={36} className="object-cover p-3" />
                </div>
            </div>

            {/* Right Side: User Info and Logout */}
            <div className="flex items-center space-x-2 md:space-x-4" ref={menuRef}>
                <div className="flex items-center space-x-2">
                    <span className="text-white text-sm font-medium hidden md:flex items-center">
                        {user_name}
                    </span>
                </div>
                <button
                    className="h-8 w-8 bg-purple-500 rounded-full flex items-center justify-center text-white text-xs font-bold select-none ring-2 ring-white shadow-lg"
                    onClick={() => setShowProfileMenu(v => !v)}
                    aria-label="User Profile"
                >
                    <FaUser className="w-4 h-4" />
                </button>

                {showProfileMenu && (
                    <div className="absolute right-4 top-16 mt-2 w-56 bg-white rounded-xl shadow-lg ring-1 ring-gray-200 p-4 z-50">
                        <div className="mb-4 flex flex-col items-center">
                            <div className="h-10 w-10 rounded-full bg-purple-500 flex items-center justify-center">
                                <FaUser className="text-white w-5 h-5" />
                            </div>
                            <span className="mt-2 font-semibold text-gray-800">{user_name}</span>
                        </div>
                        {!(pathname && pathname.startsWith('/copyediting/accept')) && (
                            <button onClick={handleLogout} className="w-full px-4 py-2 flex items-center space-x-2 text-gray-700 hover:bg-purple-100 rounded-lg transition duration-150">
                                <FaSignOutAlt className="w-4 h-4" />
                                <span>Logout</span>
                            </button>
                        )}
                    </div>
                )}
            </div>

            
        </header>
    )
}
