// app/components/SidebarServer.jsx

import { getServerSession } from "next-auth/next";
import authOptions from "@/app/api/auth/[...nextauth]/authOptions";
import SidebarClient from "./SidebarClient";

export default async function SidebarServer() {
  const session = await getServerSession(authOptions);

  if (!session?.user) return <div>Please log in</div>;

  const {
    primaryMenus = [],
    secondaryMenus = [],
    tertiaryMenus = [],
    userPermissions = {}
  } = session.user;

  // ✅ Convert permissions to arrays of strings
  const allowedPrimary = userPermissions.up_primary_menus?.split(",") || [];
  const allowedSecondary = userPermissions.up_secondary_menus?.split(",") || [];
  const allowedTertiary = userPermissions.up_tertiary_menus?.split(",") || [];

  // ✅ Filter primary menus
  const accessiblePrimaryMenus = primaryMenus.filter(menu =>
    allowedPrimary.includes(String(menu.pm_pid))
  );

  const links = accessiblePrimaryMenus.map(primary => {
  const filteredSecondary = secondaryMenus
    .filter(s => String(s.primaryMenuId) === String(primary.pm_pid))
    .filter(s => allowedSecondary.includes(String(s.sm_id)))
    .sort((a, b) => a.sm_order - b.sm_order)
    .map(sec => {
      const subSub = tertiaryMenus
        .filter(t => String(t.tm_secondaryMenuId) === String(sec.sm_id))
        .filter(t => allowedTertiary.includes(String(t.tm_id)))
        .sort((a, b) => a.tm_order - b.tm_order)
        .map(t => ({
          id: `t-${t.tm_id}`,   // ✅ unique key base
          href: t.tm_href,
          label: t.tm_label,
          icon: t.tm_icon || null,
        }));

      return {
        id: `s-${sec.sm_id}`,   // ✅ unique key base
        href: sec.sm_href,
        label: sec.sm_label,
        icon: sec.sm_icon || null,
        submenu: subSub.length ? subSub : null,
      };
    });

  return {
    id: `p-${primary.pm_pid}`,  // ✅ unique key base
    href: primary.pm_href,
    label: primary.pm_label,
    icon: primary.pm_icon || null,
    order: primary.pm_order,
    submenu: filteredSecondary.length ? filteredSecondary : null,
  };
});


  const sortedLinks = links.sort((a, b) => a.order - b.order);

  return <SidebarClient links={sortedLinks} />;
}
