// app/components/common/selectStyles.js

const selectStyles = {
    menuPortal: (base) => ({ ...base, zIndex: 9999 }),

    control: (base) => ({
      ...base,
      minHeight: "32px",
      height: "32px",
      borderRadius: "6px",
      fontSize: "12px",
    }),

    valueContainer: (base) => ({
      ...base,
      padding: "2px 6px",
      height: "32px",
    }),

    indicatorsContainer: (base) => ({
      ...base,
      height: "32px",
    }),

    input: (base) => ({
      ...base,
      margin: 0,
      padding: 0,
    }),

    // 🔥 Add these to shrink dropdown items
    menu: (base) => ({
      ...base,
      fontSize: "14px",
    }),

    menuList: (base) => ({
      ...base,
      paddingTop: 0,
      paddingBottom: 0,
    }),

    option: (base, state) => ({
      ...base,
      padding: "4px 8px",
      fontSize: "14px",
      backgroundColor: state.isSelected
        ? "#8C3FE1"
        : state.isFocused
        ? "#E9D8FD"
        : "white",
      color: state.isSelected ? "white" : "black",
      cursor: "pointer",
    }),
  };

export default selectStyles;
