"use client"

import { useEffect, useState } from "react"
import { useRouter, useSearchParams, usePathname } from "next/navigation"
import { signOut, useSession } from "next-auth/react"
import Image from "next/image"
import { toast } from "react-toastify"

export default function Header() {
  const { data: session, status } = useSession();
  const router = useRouter();
  const searchParams = useSearchParams();
  const pathname = usePathname();

  const [dropdownOpen, setDropdownOpen] = useState(false);
  const [notified, setNotified] = useState(false);

  const signedOut = searchParams.get('signedOut');
  const user = session?.user
  console.log(status);
  // Redirect to login if no session
  useEffect(() => {
    if (status === "unauthenticated") {
      router.push("/login")
    }
  }, [status, router])

  // Show logout toast if redirected with signedOut param
  useEffect(() => {
    if (!notified && signedOut) {
      toast.success("You have been logged out.")
      setNotified(true)
      router.replace("/") // Remove query param
    }
  }, [signedOut, notified, router])

  if (status === "loading") {
    return <div className="p-4">Loading...</div>
  }

  const handleLogout = async () => {
    try {
      toast.success("You have been logged out.")
      await signOut({ callbackUrl: "/login" }) // send back to login
      fetch("/api/auth/logout", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
      }).catch(console.error)
    } catch (error) {
      console.error("Logout error:", error)
      toast.error("An error occurred during logout.")
    }
  }

  return (
    <header className="bg-white shadow px-4 py-2 flex justify-between items-center">
      {/* <h2 className="text-xl font-semibold"> {segmentValue.charAt(0).toUpperCase() + segmentValue.slice(1)} {segmentValue === "list" ? "Of" : ""}{" "}{segmentValue1.charAt(0).toUpperCase() + segmentValue1.slice(1)}</h2> */}
      <h2>&nbsp;</h2>

      {/* User Avatar and Dropdown */}
      <div className="relative">
        <button
          onClick={() => setDropdownOpen(!dropdownOpen)}
          className="flex items-center space-x-3 focus:outline-none"
        >
          {user?.profile ? (
            <div className="w-10 h-10 rounded-full overflow-hidden">
              <Image
                src={`/emp_profile/${user.profile}`}
                alt="Profile"
                width={40}
                height={40}
                className="object-cover w-full h-full"
              />
            </div>
          ) : (
            <div className="w-10 h-10 bg-gray-300 rounded-full flex items-center justify-center">
              <span className="text-gray-600 font-bold">
                {user?.name?.[0] || "U"}
              </span>
            </div>
          )}
          <span className="font-medium cursor-pointer">{user?.name || "User"}</span>
          <svg
            className={`w-4 h-4 transition-transform duration-200 ${dropdownOpen ? "rotate-180" : ""}`}
            fill="none"
            stroke="currentColor"
            viewBox="0 0 24 24"
          >
            <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M19 9l-7 7-7-7" />
          </svg>
        </button>

        {/* Dropdown Menu */}
        {dropdownOpen && (
          <div className="absolute right-0 mt-2 w-45 bg-white border border-gray-200 rounded-lg shadow-xl z-20 animate-fade-in cursor-pointer">
            {/* Profile */}
            <button
              onClick={() => router.push("/profile")}
              className="flex items-center gap-2 w-full text-left px-4 py-3 text-sm text-gray-700 hover:bg-gray-100 transition cursor-pointer"
            >
              <svg
                className="w-5 h-5 text-blue-500"
                fill="none"
                stroke="currentColor"
                strokeWidth={2}
                viewBox="0 0 24 24"
              >
                <path
                  strokeLinecap="round"
                  strokeLinejoin="round"
                  d="M5.121 17.804A9 9 0 1118.88 6.196 9 9 0 015.12 17.805zM15 11a3 3 0 11-6 0 3 3 0 016 0z"
                />
              </svg>
              Profile
            </button>

            {/* Logout */}
            <button
              onClick={handleLogout}
              className="flex items-center gap-2 w-full text-left px-4 py-3 text-sm text-gray-700 hover:bg-gray-100 transition cursor-pointer"
            >
              <svg
                className="w-5 h-5 text-red-500"
                fill="none"
                stroke="currentColor"
                strokeWidth={2}
                viewBox="0 0 24 24"
              >
                <path strokeLinecap="round" strokeLinejoin="round" d="M17 16l4-4m0 0l-4-4m4 4H7" />
              </svg>
              Logout
            </button>
          </div>
        )}
      </div>
    </header>
  )
}
