"use client";

import React from "react";

export default function BooksListShimmer() {
  return (
    <div className="max-w-full px-2 py-2 mx-auto rounded-lg space-y-4 animate-pulse">
      {/* Header */}
      <header>
        <div className="flex justify-between items-center border-b border-purple-500 pb-2">
          <div className="mb-1 space-y-2">
            <div className="h-6 bg-gray-300 rounded w-40"></div>
            <div className="h-4 bg-gray-200 rounded w-64"></div>
          </div>
          <div className="h-8 w-28 bg-gradient-to-r from-gray-200 via-gray-300 to-gray-200 rounded-md"></div>
        </div>
      </header>

      {/* Filters */}
      {/* <div className="bg-purple-50 border border-purple-200 rounded-lg p-3 shadow-sm">
        <div className="flex flex-wrap gap-4 items-center justify-start">
        
          <div className="flex flex-col space-y-1">
            <div className="h-3 bg-gray-200 rounded w-10"></div>
            <div className="h-8 bg-gray-200 rounded-md w-40"></div>
          </div>

        
          <div className="pt-5">
            <div className="h-8 w-24 bg-gray-200 rounded-md"></div>
          </div>
        </div>
      </div> */}

      {/* Table Shimmer */}
      <div className="w-full mt-4 border border-gray-200 rounded-lg overflow-hidden">
        {/* Table Header */}
        <div className="bg-gray-100 flex items-center border-b border-gray-200 px-4 py-3">
          {[...Array(5)].map((_, i) => (
            <div
              key={i}
              className="h-4 bg-gray-300 rounded mx-2"
              style={{ width: `${12 + i * 5}%` }}
            ></div>
          ))}
        </div>

        {/* Table Body */}
        <div className="divide-y divide-gray-100">
          {[...Array(6)].map((_, i) => (
            <div
              key={i}
              className="flex items-center px-4 py-3 bg-white"
            >
              {[...Array(5)].map((_, j) => (
                <div
                  key={j}
                  className="h-4 bg-gray-200 rounded mx-2"
                  style={{ width: `${12 + j * 5}%` }}
                ></div>
              ))}
            </div>
          ))}
        </div>
      </div>
    </div>
  );
}
