import Layout from "@/app/components/layout";
import UsersList from "./UserList";
import { getAllUsers,getAllRoles } from '@/lib/services/userService'; 


export const dynamic = "force-dynamic"; // ensure fresh DB read

export default async function UsersListPage() {
    const  users = await getAllUsers();
    const roles = await getAllRoles();
    return (
        <Layout>
            <UsersList
             initialUsers={users} 
             roles ={roles} 
            />
        </Layout>
    );
}