import fs from "fs";
import path from "path";
import { NextResponse } from "next/server";
import { compressDocFile } from "@/lib/filecompressed/fileCompressor.js";

export const config = {
  api: {
    bodyParser: false,
  },
};

export async function POST(req) {
  try {
    const formData = await req.formData();
    const file = formData.get("file");
    const dpi = formData.get("dpi") || "96"; // Get user choice

    if (!file) {
      return NextResponse.json({ success: false, error: "No file uploaded" });
    }

    const result = await compressDocFile(file, dpi);

    if (!result.success) {
      return NextResponse.json({ success: false, error: result.message });
    }

    // Return compressed info
    return NextResponse.json({
      success: true,
      originalSize: result.originalSize,
      compressedSize: result.compressedSize,
      outputFile: result.outputFile,
      downloadUrl: `/compressed/${result.outputFile}`,
    });
  } catch (err) {
    console.error("Upload error:", err);
    return NextResponse.json({ success: false, error: err.message });
  }
}
