const secondsToTimeFormat = (totalSeconds) => {
  const hours = Math.floor(totalSeconds / 3600); // Get the number of hours
  const minutes = Math.floor((totalSeconds % 3600) / 60); // Get the number of minutes
  const seconds = totalSeconds % 60; // Get the remaining seconds

  return `${hours.toString().padStart(2, '0')}:${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
};
export const getUserPerformanceColumns = () => [
    {
        label: "Owned By",
        name: "Owned By",
        selector: (row) => row.user_name,
    },
    {
        label: "Task Name",
        name: "Task Name",
        selector: (row) => row.tasks.join('\n'),
        cell: (row) => <span style={{ whiteSpace: 'pre-line' }}>{row.tasks.join('\n')}</span>,
    },
    {
        label: "Average",
        name: "Average",
        selector: (row) => row.avg_duration_per_user,
    },
    {
        label: "Total",
        name: "Total",
        selector: (row) => row.task_count,
    },
    // {
    //     label: "Task Name",
    //     name: "Task Name",
    //     selector: (row) => row.tasks,
    // },
    // {
    //     label: "Task Name",
    //     name: "Task Name",
    //     selector: (row) => {
    //         const seenTaskPids = new Set(); // Keep track of seen task_pid values
    //         return row.task_details
    //             .filter(task => {
    //                 if (row.task_ids && row.task_ids.includes(task.task_pid)) {
    //                     if (seenTaskPids.has(task.task_pid)) {
    //                         return false; // Skip if task_pid has already been seen
    //                     }
    //                     seenTaskPids.add(task.task_pid); // Mark this task_pid as seen
    //                     return true;
    //                 }
    //                 return false;
    //             })
    //             .map(task => task.task_name);
    //     },
    //     cell: (row) => {
    //         const seenTaskPids = new Set(); // Keep track of seen task_pid values
    //         return (
    //             <div>
    //                 {row.task_details
    //                     .filter(task => {
    //                         if (row.task_ids && row.task_ids.includes(task.task_pid)) {
    //                             if (seenTaskPids.has(task.task_pid)) {
    //                                 return false; // Skip if task_pid has already been seen
    //                             }
    //                             seenTaskPids.add(task.task_pid); // Mark this task_pid as seen
    //                             return true;
    //                         }
    //                         return false;
    //                     })
    //                     .map((task, idx) => (
    //                         <div key={idx}>{task.task_name}</div> // Display task name
    //                     ))}
    //             </div>
    //         );
    //     },
    // },
    // {
    // label: "Average",
    // name: "Average",
    // selector: (row) => {
    //         const seenTaskPids = new Set(); // Keep track of seen task_pid values
    //         return row.task_details
    //             .filter(task => {
    //                 if (row.task_ids && row.task_ids.includes(task.task_pid)) {
    //                     if (seenTaskPids.has(task.task_pid)) {
    //                         return false; // Skip if task_pid has already been seen
    //                     }
    //                     seenTaskPids.add(task.task_pid); // Mark this task_pid as seen
    //                     return true;
    //                 }
    //                 return false;
    //             })
    //             .map((task, idx) => {
    //                     const avgDuration = task.task_count !== 0 
    //                         ? Math.round(task.total_duration_in_seconds / task.task_count) // Round to nearest integer
    //                         : 0;
    //             return (
    //                         <div key={idx}>
    //                             {secondsToTimeFormat(avgDuration)}
    //                         </div>
    //                     );
    //     });
    //     },
    //     cell: (row) => {
    //     const seenTaskPids = new Set(); // Keep track of seen task_pid values
    //     return (
    //         <div>
    //             {row.task_details
    //                 .filter(task => {
    //                     if (row.task_ids && row.task_ids.includes(task.task_pid)) {
    //                         if (seenTaskPids.has(task.task_pid)) {
    //                             return false; // Skip if task_pid has already been seen
    //                         }
    //                         seenTaskPids.add(task.task_pid); // Mark this task_pid as seen
    //                         return true;
    //                     }
    //                     return false;
    //                 })
    //                 .map((task, idx) => {
    //                     const avgDuration = task.task_count !== 0 
    //                         ? Math.round(task.total_duration_in_seconds / task.task_count) // Round to nearest integer
    //                         : 0;
                        
    //                     return (
    //                         <div key={idx}>
    //                             {secondsToTimeFormat(avgDuration)}
    //                         </div>
    //                     );
    //                 })}
    //         </div>
    //     );
    // }
    // },

  // {
  //   label: "Task Name",
  //   name: "Task Name",
  //   selector: (row) => {
  //     const uniqueTaskNames = [...new Set(row.task_details.map(task => task.task_name))];
  //     return uniqueTaskNames.join("\n");
  //   },
  //   cell: (row) => {
  //     const uniqueTaskNames = [...new Set(row.task_details.map(task => task.task_name))];

  //     return (
  //       <div>
  //         {uniqueTaskNames.map((taskName, idx) => (
  //           <div key={idx}>{taskName}</div>  // Display each task name on a new line
  //         ))}
  //       </div>
  //     );
  //   },
  // },
    // {
    //     label: "Total",
    //     name: "Total",
    //     selector: (row) => {
    //         const seenTaskPids = new Set(); // Keep track of seen task_pid values
    //         return row.task_details
    //             .filter(task => {
    //                 if (row.task_ids && row.task_ids.includes(task.task_pid)) {
    //                     if (seenTaskPids.has(task.task_pid)) {
    //                         return false; // Skip if task_pid has already been seen
    //                     }
    //                     seenTaskPids.add(task.task_pid); // Mark this task_pid as seen
    //                     return true;
    //                 }
    //                 return false;
    //             })
    //             .map(task => task.task_count)
    //     },
    //     cell: (row) => {
    //         const seenTaskPids = new Set(); // Keep track of seen task_pid values
    //         return (
    //             <div>
    //                 {row.task_details
    //                     .filter(task => {
    //                         if (row.task_ids && row.task_ids.includes(task.task_pid)) {
    //                             if (seenTaskPids.has(task.task_pid)) {
    //                                 return false; // Skip if task_pid has already been seen
    //                             }
    //                             seenTaskPids.add(task.task_pid); // Mark this task_pid as seen
    //                             return true;
    //                         }
    //                         return false;
    //                     })
    //                     .map((task, idx) => (
    //                         <div key={idx}>{task.task_count}</div> // Display task count
    //                     ))}
    //             </div>
    //         );
    //     },
    // }

];
