import Layout from "@/app/components/layout";
import BooksReport from "./BookReport";
import { getAllBooks } from '@/lib/services/bookService';
import { getServerSession } from 'next-auth';
import authOptions from "@/app/api/auth/[...nextauth]/authOptions"
export const dynamic = "force-dynamic"; // ensure fresh DB read

export default async function BooksListPage() {
    const session = await getServerSession(authOptions);
    const user_role = session?.user.role;
    const books = await getAllBooks();
    
    //const booksReport = await getBookEntryReport();
    
    return (
        <Layout>
            <BooksReport
                //initialReport = {booksReport}
                bookList={books}
                role = {user_role}
            />
        </Layout>
    );
}