// columns.js
import { FiEdit, FiTrash2 } from "react-icons/fi";
import { Tooltip } from "react-tooltip";

export const getQueriesColumns = (router, handleDelete, user_pid ) => [
  {
    label: "S.No",
    name: 'S.No',
    cell: (row, index) => index + 1,
    width: '70px',
  },
  {
    label: "Book Name ",
    name: 'Book Name',
    selector: (row) => row?.book.book_title,
  },
  {
    label: "Chapter Name",
    name: "Chapter Name",
    selector: (row) => row?.chapter.chap_title,
  },
  {
    label: "Task Name",
    name: 'Task Name',
    selector: (row) => row?.task.task_name,
    
  },

  {
    label: "Query",
    name: "Query",
    selector: (row) => row?.queries_name,
  },
  {
    label: "Reply Query",
    name: "Reply Query",
    selector: (row) => row?.queries_name_reply? row?.queries_name_reply : '-',
  },
  {
    label: "Replied by",
    name: 'Replied by',
    selector: (row) => row?.user_repliedBy?.user_name? row?.user_repliedBy.user_name : '-',

  },
  {
    label: "Date of Query",
    name: "Date of Query",
    selector: (row) => {
      const date = new Date(row?.queries_createdAt);
      if (isNaN(date.getTime())) return 'Invalid Date';

      const year = date.getFullYear();
      const month = String(date.getMonth() + 1).padStart(2, '0'); // Months are 0-based
      const day = String(date.getDate()).padStart(2, '0');

      return `${year}-${month}-${day}`;
    },
  },
  {
    label: "Action",
    name: 'Action',
    cell: (row) => (
      <div className="flex space-x-3">
        {/* Edit */}
        <button
          onClick={() => router.push(`/queries/create?id=${row?.queries_pid}`)}
          data-tooltip-id={`edit-tooltip-${row?.queries_pid}`}
          data-tooltip-content="Edit"
          className="text-blue-600 hover:text-blue-800 cursor-pointer"
          type="button"
        >
          <FiEdit size={20} />
          <Tooltip
            id={`edit-tooltip-${row?.queries_pid}`}
            place="top"
            style={{
              backgroundColor: '#3b82f6',
              color: '#fff',
              fontSize: '12px',
              borderRadius: '4px',
              padding: '6px 10px',
               zIndex: "1000",
            }}
          />
        </button>

        {/* Delete */}
        {user_pid == row?.queries_createdBy && (
          <button
            onClick={() => handleDelete(row?.queries_pid, row.queries_name)}
            data-tooltip-id={`delete-tooltip-${row?.queries_pid}`}
            data-tooltip-content="Delete"
            className="text-red-600 hover:text-red-800 cursor-pointer"
            type="button"
          >
            <FiTrash2 size={20} />
            <Tooltip
              id={`delete-tooltip-${row?.queries_pid}`}
              place="top"
              style={{
                backgroundColor: '#ef4444',
                color: '#fff',
                fontSize: '12px',
                borderRadius: '4px',
                padding: '6px 10px',
                 zIndex: "1000",
              }}
            />
          </button>
        )}
      </div>
    ),
    ignoreRowClick: true,
  },
];
