// app/users/create/page.jsx
import Layout from "@/app/components/layout";
import CreateQueriesform from "./CreateQueriesForm";
import { getAllBooks } from '@/lib/services/bookService';
import { getServerSession } from 'next-auth';
import authOptions from "@/app/api/auth/[...nextauth]/authOptions"
export const dynamic = "force-dynamic"; // ensure fresh DB read
import { getAllTasks } from "@/lib/services/taskService";
import { getQueryById } from "@/lib/services/queryService"; 

export default async function CreateQueriesPage( props ) {
    const session = await getServerSession(authOptions);
    const books = await getAllBooks();
    const tasks = await getAllTasks();
    const user_pid = session?.user.user_pid;
    // const params = await searchParams;
    const queriesPid = await props?.searchParams?.id || null;
    let queriesData = null;
    
    console.log("queriesPid", queriesPid);
    
    if (queriesPid) {
        queriesData = await getQueryById(Number(queriesPid));
    }

    return (
        <Layout>
            <CreateQueriesform
                booksData={books}
                taskData={tasks}
                queriesPid={queriesPid}
                queriesData={queriesData}
                user_pid = {user_pid}
            />
        </Layout>
    );
}