// columns.js
import { FiEdit, FiTrash2 } from "react-icons/fi";
import { Tooltip } from "react-tooltip";

export const getKnowledgeColumns = (router, handleDelete) => [
  {
    label: "S.No",
    name: 'S.No',
    cell: (row, index) => index + 1,
    width: '70px',
  },
  {
    label: "Knowledge Name",
    name: 'Knowledge Name',
    selector: (row) => row?.knowledge_name,
  },
 {
  label: "Knowledge File",
  name: "Knowledge File",
  cell: (row) =>
    row.knowledge_file ? (
      <a
        href={`/Knowledge/${row.knowledge_file}`}
        target="_blank"
        rel="noopener noreferrer"
        className="text-blue-600 underline hover:text-blue-800"
      >
        {row.knowledge_file}
      </a>
    ) : (
      'No File'
    ),
},
  {
    label: "Upload on",
    name: 'Upload on',
    selector: (row) => {
      const date = new Date(row?.knowledge_createdAt);
      if (isNaN(date.getTime())) return 'Invalid Date';

      const year = date.getFullYear();
      const month = String(date.getMonth() + 1).padStart(2, '0'); // Months are 0-based
      const day = String(date.getDate()).padStart(2, '0');

      return `${year}-${month}-${day}`;
    },
  },

  {
    label: "Upload by",
    name: 'Upload by',
    selector: (row) => row?.user.user_name,

  },

  {
    label: "Action",
    name: 'Action',
    cell: (row) => (
      <div className="flex space-x-3">
        {/* Edit */}
        <button
          onClick={() => router.push(`/knowledge/create?id=${row?.knowledge_pid}`)}
          data-tooltip-id={`edit-tooltip-${row?.knowledge_pid}`}
          data-tooltip-content="Edit"
          className="text-blue-600 hover:text-blue-800 cursor-pointer"
          type="button"
        >
          <FiEdit size={20} />
          <Tooltip
            id={`edit-tooltip-${row?.knowledge_pid}`}
            place="top"
            style={{
              backgroundColor: '#3b82f6',
              color: '#fff',
              fontSize: '12px',
              borderRadius: '4px',
              padding: '6px 10px',
               zIndex: "1000",
            }}
          />
        </button>

        {/* Delete */}
        <button
          onClick={() => handleDelete(row?.knowledge_pid, row.knowledge_name)}
          data-tooltip-id={`delete-tooltip-${row?.knowledge_pid}`}
          data-tooltip-content="Delete"
          className="text-red-600 hover:text-red-800 cursor-pointer"
          type="button"
        >
          <FiTrash2 size={20} />
          <Tooltip
            id={`delete-tooltip-${row?.knowledge_pid}`}
            place="top"
            style={{
              backgroundColor: '#ef4444',
              color: '#fff',
              fontSize: '12px',
              borderRadius: '4px',
              padding: '6px 10px',
               zIndex: "1000",
            }}
          />
        </button>
      </div>
    ),
    ignoreRowClick: true,
  },
];
