// app/users/create/page.jsx
import Layout from "@/app/components/layout";
import CreateKnowledgeForm from "./CreateKnowledgeForm";
import { getKnowledgeById } from "@/lib/services/knowledgeService";
import { getServerSession } from 'next-auth';
import authOptions from "@/app/api/auth/[...nextauth]/authOptions"
export const dynamic = "force-dynamic"; // ensure fresh DB read

export default async function CreateKnowledgePage( props ) {
    const session = await getServerSession(authOptions);
    const user_pid = session?.user.user_pid;
    // const knowledgeId = await searchParams.id;
    const params = await props?.searchParams;
    const knowledgeId = params.id;
    let knowledge = null;
    if (knowledgeId) {
        knowledge = await getKnowledgeById(Number(knowledgeId));
    }

    return (
        <Layout>
            <CreateKnowledgeForm
                knowledge={knowledge}
                knowledgeId={knowledgeId}
                user_pid = {user_pid}
            />
        </Layout>
    );
}