import Layout from "@/app/components/layout";
import CreateEntryEditForm from "./CreateEntryEditForm";
import { getAllBooks } from "@/lib/services/bookService";
import { getEntryById, getAllTasks, getAllStatus, getAllQCEmails } from "@/lib/services/entryService";
import { getAllChapters } from '@/lib/services/chapterService';


export const dynamic = "force-dynamic";

export default async function CreateEntryEditPage( props ) {

    // const entryId = searchParams.id;
    const params = await props?.searchParams;
    const entryId = params.id;

    // Fetch books + pstatus server-side
    const [books, chapters, tasks, status, emails, entry] = await Promise.all([
        getAllBooks(),
        getAllChapters(),
        getAllTasks(),
        getAllStatus(),
        getAllQCEmails(),
        entryId ? getEntryById(entryId) : null,
    ]);
    // console.log(breaks);
    return (
        <Layout>
            <CreateEntryEditForm
                initialBooks={books}
                initialchapters={chapters}
                initialtasks={tasks}
                initialstatus={status}
                initialemails={emails}
                entry={entry}
            />
        </Layout>
    );
}