import { getAllBooks } from "@/lib/services/bookService";
import Layout from "../../../components/copyedit-layout";
import CopyEditingList from "./CopyEditingList";
import { getAllChaptersByCE } from "@/lib/services/chapterService";
import { getAllCeEditingDetails } from "@/lib/services/copyeditingService";
import { getServerSession } from "next-auth";
import authOptions from "@/app/api/auth/[...nextauth]/authOptions";


export const dynamic = "force-dynamic"; // ensure fresh DB read

export default async function CopyEditingPage() {
   const session = await getServerSession(authOptions);
    const user_pid = session?.user?.user_pid;
    console.log(user_pid, "user_pid in dashboard page");
    const book = await getAllBooks();
    const bookIds = book.map(book => book.book_pid);
    const copyediting = await getAllChaptersByCE(bookIds);
    const acs_ce_editing_details = await getAllCeEditingDetails( user_pid);
    console.log("CE Editing Details:", acs_ce_editing_details);                           
  return (
    <Layout>
      <CopyEditingList 
        initialBooks={book}
        initialCopyediting={copyediting}
        initialCeEditingDetails={acs_ce_editing_details}
      />
    </Layout>
  );
}
