// app/chapters/create/page.jsx
import Layout from "@/app/components/layout";
import ViewChapterDetails from "./ViewChapterDetails";
import { getChapterById, getAllChapterDetails } from "@/lib/services/chapterService";
import { notFound } from "next/navigation";
import { getServerSession } from 'next-auth';
import authOptions from "@/app/api/auth/[...nextauth]/authOptions"
import { getDecryptChapterNumber } from "@/lib/actions/chapterActions";
export const dynamic = "force-dynamic";

export default async function CreateDetailsPage( props ) {
    const session = await getServerSession(authOptions);
    const user_pid = session?.user.user_pid;
    const user_role = session?.user.role;
    // const chapterId = await searchParams.id;
    const params =  await props?.searchParams;
    const chapterIdEncrypt = params.id;

    const decryptId = await getDecryptChapterNumber(chapterIdEncrypt);
    const chapterId = decryptId?.decryptId;

    const chapter   = await getAllChapterDetails(chapterId);
    if (chapterId && !chapter) {
        notFound();
    }
    return (
        <Layout>
            <ViewChapterDetails
                initialChapter={chapter}
                chapterId={chapterId}
                user_pid = {user_pid}
                role= {user_role}
            />
        </Layout>
    );
}
