"use client";

import React, { useEffect, useMemo, useState } from 'react';
import { BookOpen, TrendingUp, FileText, ChevronDown, ChevronUp, Calendar, User, Hash, MessageSquare, Users, BadgeCheckIcon } from 'lucide-react';
import { useRouter } from "next/navigation";
//import CustomDataTable from '../dataTable/customDataTable';
import { getChapterDetailsColumns } from './columns';
import { TfiBook } from "react-icons/tfi";
export default function ViewChapterDetails(initialChapter, chapterId, user_pid, role) {
    const [data, setData] = useState(initialChapter || []);
    const [loading, setLoading] = useState(true);
    const [expandedIndex, setExpandedIndex] = useState(null);
    const [isOpen, setIsOpen] = useState(false);
    const router = useRouter();

    useEffect(() => {
        setData(initialChapter || []);
        setLoading(false);
    }, [initialChapter]);

    const chapterData = data.initialChapter[0];
    const bookData = data.initialChapter[0]?.book;
    const stageMovementData = data.initialChapter[0]?.stage_movements;

    const formatDate = (dateString) => {
        const date = new Date(dateString);
        if (isNaN(date)) return "-"; // handle invalid date
        const mm = String(date.getMonth() + 1).padStart(2, "0");
        const dd = String(date.getDate()).padStart(2, "0");
        const yyyy = date.getFullYear();
        return `${dd}-${mm}-${yyyy}`;
    };
    const columns = useMemo(() => getChapterDetailsColumns(router, role, bookData, chapterData), [router, role, bookData, chapterData]);

    const toggleAccordion = (index) => {
        setExpandedIndex(expandedIndex === index ? null : index);
    };

    const bookDetails = [
        { icon: Calendar, label: "Book Year Title", value: bookData?.book_year, labelColor: "text-blue-600", valueColor: "text-blue-900" },
        { icon: BookOpen, label: "Book Name", value: bookData?.book_title, labelColor: "text-purple-600", valueColor: "text-purple-900" },
        { icon: User, label: "Lead Editor", value: bookData?.book_LeadEditorName, labelColor: "text-green-600", valueColor: "text-green-900" },
        { icon: Hash, label: "Customer ID", value: bookData?.book_CustomId, labelColor: "text-orange-600", valueColor: "text-orange-900" },
        { icon: FileText, label: "ISBN", value: bookData?.book_OnlineIsbn, labelColor: "text-red-600", valueColor: "text-red-900" },
        { icon: MessageSquare, label: "Book Notes", value: bookData?.book_NoteComments, labelColor: "text-teal-600", valueColor: "text-teal-900" },
        { icon: Users, label: "Project Manager", value: bookData?.pm_user?.user_name, labelColor: "text-indigo-600", valueColor: "text-indigo-900" },
        { icon: Calendar, label: "Book Create Date", value: formatDate(bookData?.book_createdAt), labelColor: "text-pink-600", valueColor: "text-pink-900" }
    ];

    const stageLabels = {
        FC: { name: "First Check", bgColor: "bg-blue-100", textColor: "text-blue-800" },
        FCR: { name: "First Check Resubmit", bgColor: "bg-green-100", textColor: "text-green-800" },
        FCQC: { name: "First Check QC", bgColor: "bg-purple-100", textColor: "text-purple-800" },
        FCRQC: { name: "First Check Resubmit QC", bgColor: "bg-orange-100", textColor: "text-orange-800" },
        EDA: { name: "Editor Assignment", bgColor: "bg-red-100", textColor: "text-red-800" },
        PR: { name: "Peer Review", bgColor: "bg-teal-100", textColor: "text-teal-800" },
        MD: { name: "Make Decision", bgColor: "bg-indigo-100", textColor: "text-indigo-800" },
        RCR1: { name: "Revision Check 1", bgColor: "bg-blue-100", textColor: "text-blue-800" },
        CE: { name: "Copy Editing", bgColor: "bg-green-100", textColor: "text-green-800" },
        RCR2: { name: "Revision Check 2", bgColor: "bg-purple-100", textColor: "text-purple-800" },
        ER: { name: "Editor Recommendation", bgColor: "bg-orange-100", textColor: "text-orange-800" },
        RCBTR: { name: "Revision Check Books Team Review", bgColor: "bg-red-100", textColor: "text-red-800" },
        RCQC: { name: "Revision Check Quality Check", bgColor: "bg-teal-100", textColor: "text-teal-800" },
        RCER: { name: "Revision Check Editor Recommendation", bgColor: "bg-pink-100", textColor: "text-pink-800" },
    };

    return (
        <div className="min-h-screen bg-gray-50">
            {/* Header - No Background Color */}
            <section className="py-3 border-b border-gray-200">
                <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                    <div className="flex items-center justify-center">
                        <div className="text-center flex items-center gap-3">
                            <FileText className="text-purple-600 text-5xl -mt-2" />
                            <h3 className="text-2xl font-bold text-gray-900 mb-2 uppercase">
                                {bookData?.book_title} - {chapterData.chap_title}
                            </h3>
                        </div>
                    </div>
                </div>
            </section>


            {/* Book Details - Label & Data Format */}
            <section className="py-1 bg-white ">

                <div className="bg-gradient-to-br from-blue-50 via-white to-purple-50 py-4 px-4">
                    <div className="max-w-5xl mx-auto">
                        {/* Accordion Card */}
                        <div className="bg-white rounded-2xl shadow-xl overflow-hidden border border-gray-200">
                            {/* Accordion Header - Clickable */}
                            <div
                                onClick={() => setIsOpen(!isOpen)}
                                className="cursor-pointer hover:bg-gray-50 transition-all duration-300"
                            >
                                <div className="flex items-center gap-6 p-4">
                                    {/* Book Image */}
                                    <div className="relative flex-shrink-0 group">

                                        {/* Overlay indicator */}
                                        <div className="absolute inset-0 bg-black/0 group-hover:bg-black/10 rounded-lg transition-all duration-300 flex items-center justify-center">
                                            <div className="opacity-0 group-hover:opacity-100 transition-opacity duration-300 bg-white/90 rounded-full p-2">
                                                {isOpen ? <ChevronUp className="w-5 h-5 text-blue-600" /> : <ChevronDown className="w-5 h-5 text-blue-600" />}
                                            </div>
                                        </div>
                                    </div>

                                    {/* Title and Basic Info */}
                                    <div className="flex-1 min-w-0">
                                        <div className="flex items-start justify-between gap-4">
                                            <div className="flex items-center space-x-3 text-center">
                                                <TfiBook className="w-6 h-6 text-purple-600 flex-shrink-0" />
                                                <h2 className="text-2xl font-bold text-gray-900 truncate">
                                                   {bookData.book_title.charAt(0).toUpperCase() + bookData.book_title.slice(1)}
                                                </h2>
                                                
                                            </div>
                                            {/* Toggle Button */}
                                            <button className="flex-shrink-0 p-2 hover:bg-blue-100 rounded-full transition-colors duration-200">
                                                {isOpen ? (
                                                    <ChevronUp className="w-6 h-6 text-blue-600" />
                                                ) : (
                                                    <ChevronDown className="w-6 h-6 text-blue-600" />
                                                )}
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            {/* Accordion Content - Expandable */}
                            <div
                                className={`transition-all duration-500 ease-in-out overflow-hidden ${isOpen ? 'max-h-[1000px] opacity-100' : 'max-h-0 opacity-0'
                                    }`}
                            >
                                <div className="border-t border-gray-200 bg-gradient-to-br from-gray-50 to-white">
                                    <div className="p-3">
                                        <h3 className="text-lg font-semibold text-blue-900 mb-6 flex items-center justify-center gap-2 text-center">
                                            <BookOpen className="w-5 h-5 text-blue-600" />
                                            Complete Book Information
                                        </h3>

                                        {/* Details Grid */}
                                        <div className="grid md:grid-cols-2 gap-4">
                                            {bookDetails.map((detail, index) => {
                                                const Icon = detail.icon;
                                                return (
                                                    <div
                                                        key={index}
                                                        className="bg-white p-2 rounded-xl border border-gray-200 shadow-sm hover:shadow-md hover:border-blue-300 transition-all duration-200"
                                                    >
                                                        <div className="flex items-start gap-3">
                                                            <div className="flex-shrink-0 w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center">
                                                                <Icon className="w-5 h-5 text-blue-600" />
                                                            </div>
                                                            <div className="flex-1 min-w-0">
                                                                <label className={`block text-sm font-semibold tracking-wide mb-1 ${detail.labelColor || 'text-gray-500'}`}>
                                                                    {detail.label}
                                                                </label>
                                                                <p className={`text-sm font-semibold break-words ${detail.valueColor || 'text-gray-900'}`}>
                                                                    {detail.value || 'N/A'}
                                                                </p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                );
                                            })}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>


            {/* Chapter Details - Label & Data Format */}
            <section className="py-4 bg-gray-50">
                <div className="max-w-7xl mx-auto px-6 sm:px-6 lg:px-8">
                    <h2 className="text-2xl font-bold text-red-900 mb-12 flex items-center justify-center gap-2 text-center">
                        <FileText className="w-6 h-6 text-purple-600" />
                        Chapter Details
                    </h2>

                    <div className="grid md:grid-cols-[45%_2px_1fr] gap-0">

                        {/* Chapter Title */}
                        <div className="pr-6 py-3 border-b border-gray-200">
                            <label className="text-sm font-semibold text-gray-600 tracking-wide float-right">
                                Chapter Title
                            </label>
                        </div>
                        <div className="bg-gray-300"></div>
                        <div className="pl-6 py-3 border-b border-gray-200">
                            <p className="text-sm font-semibold text-gray-900">{chapterData?.chap_title}</p>
                        </div>

                        {/* Manuscript ID */}
                        <div className="pr-6 py-3 border-b border-gray-200">
                            <label className="text-sm font-semibold text-gray-600 tracking-wide float-right">
                                Chapter Manuscript ID
                            </label>
                        </div>
                        <div className="bg-gray-300"></div>
                        <div className="pl-6 py-3 border-b border-gray-200">
                            <p className="text-sm font-semibold text-gray-900">{chapterData?.chap_manuscriptID}</p>
                        </div>

                        {/* First Name */}
                        <div className="pr-6 py-3 border-b border-gray-200">
                            <label className="text-sm font-semibold text-gray-600 tracking-wide float-right">
                                Chapter First Name
                            </label>
                        </div>
                        <div className="bg-gray-300"></div>
                        <div className="pl-6 py-3 border-b border-gray-200">
                            <p className="text-sm font-semibold text-gray-900">{chapterData?.chap_firstName}</p>
                        </div>

                        {/* Last Name */}
                        <div className="pr-6 py-3 border-b border-gray-200">
                            <label className="text-sm font-semibold text-gray-600 tracking-wide float-right">
                                Chapter Last Name
                            </label>
                        </div>
                        <div className="bg-gray-300"></div>
                        <div className="pl-6 py-3 border-b border-gray-200">
                            <p className="text-sm font-semibold text-gray-900">{chapterData?.chap_lastName}</p>
                        </div>

                        {/* Author Email */}
                        <div className="pr-6 py-3 border-b border-gray-200">
                            <label className="text-sm font-semibold text-gray-600 tracking-wide float-right">
                                Author Email
                            </label>
                        </div>
                        <div className="bg-gray-300"></div>
                        <div className="pl-6 py-3 border-b border-gray-200">
                            <p className="text-sm font-semibold text-gray-900 break-words">
                                {chapterData?.chap_correspondingAuthorEmail || "-"}
                            </p>
                        </div>

                        {/* Status */}
                        <div className="pr-6 py-3 border-b border-gray-200">
                            <label className="text-sm font-semibold text-gray-600 tracking-wide float-right">
                                Chapter Status
                            </label>
                        </div>
                        <div className="bg-gray-300"></div>
                        <div className="pl-6 py-3 border-b border-gray-200">
                            <p className="text-sm font-semibold text-gray-900">{chapterData?.chap_status
                                || "-"}</p>
                        </div>

                        {/* P+ Status */}
                        <div className="pr-6 py-3 border-b border-gray-200">
                            <label className="text-sm font-semibold text-gray-600 tracking-wide float-right">
                                Chapter P+ Status
                            </label>
                        </div>
                        <div className="bg-gray-300"></div>
                        <div className="pl-6 py-3 border-b border-gray-200">
                            <p className="text-sm font-semibold text-gray-900">{chapterData?.chap_pStatus || "-"}</p>
                        </div>

                        {/* P+ Due Date */}
                        <div className="pr-6 py-3 border-b border-gray-200">
                            <label className="text-sm font-semibold text-gray-600 tracking-wide float-right">
                                Chapter P+ Due Date
                            </label>
                        </div>
                        <div className="bg-gray-300"></div>
                        <div className="pl-6 py-3 border-b border-gray-200">
                            <p className="text-sm font-semibold text-gray-900">{chapterData?.chap_pdueDate || "-"}</p>
                        </div>

                        {/* Chapter copy editing */}
                        <div className="pr-6 py-3 border-b border-gray-200">
                            <label className="text-sm font-semibold text-gray-600 tracking-wide float-right">
                                Chapter Copy Editing
                            </label>
                        </div>
                        <div className="bg-gray-300"></div>
                        <div className="pl-6 py-3 border-b border-gray-200">
                            <p className="text-sm font-semibold text-gray-900">{chapterData?.chap_copyEditing || "-"}</p>
                        </div>
                        {/* Chapter copy editing */}
                        <div className="pr-6 py-3 border-b border-gray-200">
                            <label className="text-sm font-semibold text-gray-600 tracking-wide float-right">
                                Chapter Copy Editing Status
                            </label>
                        </div>
                        <div className="bg-gray-300"></div>
                        <div className="pl-6 py-3 border-b border-gray-200">
                            <p className="text-sm font-semibold text-gray-900">{chapterData?.chap_copyEditingStatus || "-"}</p>
                        </div>

                        {/* Comments */}
                        <div className="pr-6 py-3 border-b border-gray-200">
                            <label className="text-sm font-semibold text-gray-600 tracking-wide float-right">
                                Chapter Comments
                            </label>
                        </div>
                        <div className="bg-gray-300"></div>
                        <div className="pl-6 py-3 border-b border-gray-200">
                            <p className="text-sm font-semibold text-gray-900">{chapterData?.chap_comments || "-"}</p>
                        </div>

                        {/* Current Stage */}
                        <div className="pr-6 py-3 border-b border-gray-200">
                            <label className="text-sm font-semibold text-gray-600 tracking-wide float-right">
                                Chapter Current Stage
                            </label>
                        </div>
                        <div className="bg-gray-300"></div>
                        <div className="pl-6 py-3 border-b border-gray-200">
                            <p className="text-sm font-semibold text-gray-900">{chapterData?.chap_currentStage}</p>
                        </div>

                        {/* Word Count */}
                        <div className="pr-6 py-3 border-b border-gray-200">
                            <label className="text-sm font-semibold text-gray-600 tracking-wide float-right">
                                Chapter Word Count
                            </label>
                        </div>
                        <div className="bg-gray-300"></div>
                        <div className="pl-6 py-3 border-b border-gray-200">
                            <p className="text-sm font-semibold text-gray-900">{chapterData?.chap_wordcount || "-"}</p>
                        </div>

                        {/* Pre Word Count */}
                        <div className="pr-6 py-3 border-b border-gray-200">
                            <label className="text-sm font-semibold text-gray-600 tracking-wide float-right">
                                Chapter Pre Word Count
                            </label>
                        </div>
                        <div className="bg-gray-300"></div>
                        <div className="pl-6 py-3 border-b border-gray-200">
                            <p className="text-sm font-semibold text-gray-900">{chapterData?.chap_pre_wordcount || "-"}</p>
                        </div>
                    </div>
                </div>
            </section>

            <section className="py-4 bg-white">
                <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                    <div className="mb-8">
                        <h2 className="text-2xl font-bold text-green-900 mb-2 flex items-center justify-center gap-2 text-center">
                            <TrendingUp className="w-6 h-6 text-green-600" />
                            Stage Movement
                        </h2>
                    </div>

                    {loading ? (
                        <div className="flex justify-center items-center py-12">
                            <div className="animate-spin rounded-full h-12 w-12 border-b-2 border-purple-600"></div>
                        </div>
                    ) : (
                        <div className="space-y-4">
                            {stageMovementData.map((item, index) => {
                                let filename;
                                if (item.entry?.stage_from === "FC") {
                                    filename = "/First_check";
                                } else if(item?.stage_from === "FCQC") {
                                    filename = "/QCFiles";
                                } else if(item?.stage_from === "RCR1") {
                                    filename = "/Revision_check";
                                }
                              return (   
                                <div
                                    key={index}
                                    className="bg-white border-2 border-gray-200 rounded-2xl overflow-hidden transition-all duration-300"
                                >
                                    {/* Accordion Header */}
                                    <button
                                        onClick={() => toggleAccordion(index)}
                                        className="w-full bg-gray-50 p-4 border-b-2 border-gray-200 hover:bg-gray-100 transition-colors duration-200"
                                    >
                                        <div className="flex items-center justify-between">
                                            <div className="flex items-center gap-4 flex-1">
                                               <BadgeCheckIcon className="w-4 h-4 text-purple-500" />
                                                <div className="flex items-center gap-2 flex-1">
                                                    <div className="text-left">
                                                        <p className="text-xs text-gray-500">From Stage</p>
                                                        <p className={`font-bold text-sm ${stageLabels[item.stage_from]?.textColor || 'text-gray-900'}`}>
                                                            {stageLabels[item.stage_from]?.name || item.stage_from}
                                                        </p>
                                                    </div>

                                                    <svg className="w-6 h-6 text-purple-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M13 7l5 5m0 0l-5 5m5-5H6" />
                                                    </svg>

                                                    <div className="text-left">
                                                        <p className="text-xs text-gray-500">To Stage</p>
                                                        <p className={`font-bold text-sm ${stageLabels[item.stage_to]?.textColor || 'text-gray-900'}`}>
                                                            {stageLabels[item.stage_to]?.name || item.stage_to}
                                                        </p>
                                                    </div>
                                                </div>

                                                <div className="text-right mr-4">
                                                    <p className="text-xs text-gray-500">Stage Dispatch Date</p>
                                                    <p className="font-semibold text-gray-900 text-sm">
                                                        {formatDate(item.stage_dispachDate)}
                                                    </p>
                                                </div>
                                            </div>

                                            {expandedIndex === index ? (
                                                <ChevronUp className="w-5 h-5 text-gray-600" />
                                            ) : (
                                                <ChevronDown className="w-5 h-5 text-gray-600" />
                                            )}
                                        </div>
                                    </button>

                                    {/* Accordion Content */}
                                    {expandedIndex === index && (
                                        <div className="p-4 animate-in fade-in duration-300">
                                            <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
                                                {/* First Section - Left Side */}
                                                <ul className="bg-purple-50 rounded-lg p-3 space-y-2 pt-2.5 pr-0 pb-0 pl-[34px]" >
                                                    <li className="flex text-sm">
                                                        <span className="text-red-700 font-semibold text-left min-w-[120px]">Username :</span>
                                                        <span className="text-red-900 font-semibold pl-2">{item.user?.user_name || '-'}</span>
                                                    </li>
                                                    <li className="flex text-sm">
                                                        <span className="text-green-700 font-semibold text-left min-w-[120px]">Status :</span>
                                                        <span className="text-green-900 font-semibold pl-2">{item.status.status_name || '-'}</span>
                                                    </li>
                                                    <li className="flex text-sm">
                                                        <span className="text-teal-700 font-semibold text-left min-w-[120px]">Movement Date :</span>
                                                        <span className="text-teal-900 font-semibold pl-2">{formatDate(item.stage_dispachDate)}</span>
                                                    </li>
                                                    
                                                    <li className="flex text-sm">
                                                        <span className="text-cyan-700 font-semibold text-left min-w-[120px]">Stage Upload File :</span>
                                                        <span className="text-cyan-900 font-semibold pl-2">{item?.stage_uploadFile ? (
                                                            <a
                                                                href={`${filename}/${item.stage_uploadFile}`}
                                                                download
                                                                target="_blank"
                                                                rel="noopener noreferrer"
                                                                className="text-blue-600 hover:underline hover:text-blue-800"
                                                            >
                                                                Download
                                                            </a>
                                                            ) : (
                                                            "-"
                                                            )}
                                                        </span>
                                                        {/* {`/QCFiles/${fileName}`} */}
                                                    </li>
                                                </ul>

                                                {/* Second Section - Right Side */}
                                                {item.entry && (item.entry.entry_start_time || item.entry.entry_end_time || item.entry.entry_duration || item.entry.entry_end_date) && (
                                                    <ul className="bg-purple-50 rounded-lg p-3 space-y-2  pt-2.5 pr-0 pb-0 pl-[34px]">
                                                        <li className="flex text-sm">
                                                            <span className="text-pink-700 font-semibold text-left min-w-[120px]">Start Time :</span>
                                                            <span className="text-pink-900 font-semibold pl-2">{item.entry?.entry_start_time || '-'}</span>
                                                        </li>
                                                        <li className="flex text-sm">
                                                            <span className="text-purple-700 font-semibold text-left min-w-[120px]">End Time :</span>
                                                            <span className="text-purple-900 font-semibold pl-2">{item.entry?.entry_end_time || '-'}</span>
                                                        </li>
                                                        <li className="flex text-sm">
                                                            <span className="text-cyan-700 font-semibold text-left min-w-[120px]">Duration :</span>
                                                            <span className="text-cyan-900 font-semibold pl-2">{item.entry?.entry_duration || '-'}</span>
                                                        </li>
                                                        <li className="flex text-sm">
                                                            <span className="text-teal-700 font-semibold text-left min-w-[120px]">End Date :</span>
                                                            <span className="text-teal-900 font-semibold pl-2">{formatDate(item.entry?.entry_end_date)}</span>
                                                        </li>
                                                        
                                                    </ul>
                                                )}    
                                            </div>
                                        </div>
                                    )}
                                </div>
                              )}
                            )}
                        </div>
                    )}
                </div>
            </section>

            {/* Stage Movement - Grid Format */}
            {/* <section className="py-12 bg-white">
                <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                    <div className="mb-8">
                        <h2 className="text-2xl font-bold text-gray-900 mb-2 flex items-center gap-2">
                            <TrendingUp className="w-6 h-6 text-purple-600" />
                            Stage Movement
                        </h2>
                    </div>

                    <CustomDataTable
                        columns={columns}
                        data={stageMovementData}
                        progressPending={loading}
                        defaultSort={{ key: "Working Title", direction: "ascending" }}
                    />
                </div>
            </section> */}
        </div>
    );
}

