// app/books/create/page.jsx
import Layout from "@/app/components/layout";
import CreateBookForm from "./CreateBookForm";
import { getBookById} from "@/lib/services/bookService";
import { getServerSession } from 'next-auth';
import authOptions from "@/app/api/auth/[...nextauth]/authOptions"
import { getProjectUser } from "@/lib/services/userService";
export const dynamic = "force-dynamic"; // ensure fresh DB read

export default async function CreateBookPage( props ) {
    const session = await getServerSession(authOptions);
    const user_pid = session?.user.user_pid;
    // const bookId = await searchParams.id;
    const params = await props?.searchParams;

    const projectUser = await getProjectUser();
    
    const bookId = params?.id;
    let book = null;
    if (bookId) {
        book = await getBookById(Number(bookId));
    }

    return (
        <Layout>
            <CreateBookForm
                book={book}
                bookId={bookId}
                user_pid = {user_pid}
                project_user = {projectUser}
            />
        </Layout>
    );
}