<!-- DataTables -->
<link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables/dataTables.bootstrap4.css"> 
<link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
<link rel="stylesheet" href="/resources/demos/style.css">
<style>
.sortable { list-style-type: none; margin: 0; padding: 0; width: 100%; font-size: 90% !important;}
.sortable tr {height: 36px; padding:10px 10px 10px 30px;margin-left:10%;}
.sortable tr span { position: absolute; margin-left: -2%; margin-top: 0.3%;}
body
{
	counter-reset: Serial;           /* Set the Serial counter to 0 */
}

tr td.serial:before
{
  counter-increment: Serial;      /* Increment the Serial counter */
  content: counter(Serial); /* Display the counter */
}
</style>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Main content -->
    <section class="content">
      <!-- For Messages -->
      <?php $this->load->view('admin/includes/_messages.php') ?>

	  <?php if(!empty($this->uri->segment(4)))
			{
				$issue_name = $this->uri->segment(4);
			} 
			else 
			{
				$issue_name = '';
			}
			?>
      <div class="card card-default">
        <div class="card-header">
          <div class="d-inline-block">
              <h3 class="card-title"> <i class="fa fa-list"></i>
              &nbsp; List of all issues - <?php echo  $issue_name; ?></h3>
          </div>
        </div>
        <?php if($error = $this->session->flashdata('msg')){ ?>
            <div class="alert alert-success" id="msg">
                 <a href="#" class="close" data-dismiss="alert">&times;</a>
                 <strong>Success!</strong> <?php echo  $error; ?>
            </div>
        <?php } ?>
        <div class="card-body table-responsive">
          <table id="example1" class="table table-bordered table-striped ">
          <thead>
          <tr>
            <th>S.NO.</th>
            <th>JOURNAL NAME</th>
            <th>ARTICLE NO.</th>
			<th>PDF PAGES</th>
			<th>SUPPl. PDF PAGES</th>
			<th>NO. OF FIGURES</th>
			<th>PUBLISHED ONLINE DATE</th>
			<th>FIRST PAGE</th>
			<th>LAST PAGE</th>
            <th>DOI NUMBER</th>
            <th>ACTION</th>       
          </tr>
          </thead>
		 
          <tbody class="" id="tbody_<?php echo $issue_name;?>">
		  <?php if(count($issue_detail) > 0) { ?>
            <?php $s_no = 1; foreach($issue_detail as $data): //echo "<br>";print_r($data);?>
            <tr>
              <td class="serial"></td>
			  <td class="list_issue_id" style="display:none;"><?php echo $data['id']; ?></td>
              <td><?= $data['journal_name']; ?> </td>
              <td><?= $data['article_no']; ?></td>
			  <td class="no_of_pages"><?= $data['pdf_pages']; ?></td>
			  <td><?= $data['supp_pdf_pages']; ?></td>
			  <td><?= $data['nof']; ?></td>
			  <td><?php if($data['uploaded_date'] != "0000-00-00") { echo date('d-m-Y',strtotime($data['uploaded_date'])); } else { echo "-"; } ?></td>
			  <td><?= $data['first_page']; ?></td>
			  <td><?= $data['last_page']; ?></td>
              <td><?= $data['doi_number']; ?></td>
              <td><a href="<?= base_url('admin/issues/delete/'.$data['article_no']); ?>" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this item?');"><i class="fa fa-remove"></i></a></td>
            </tr>
            <?php $s_no++; endforeach; ?>
		  <?php } else {?>
		  <tr><td colspan="11" style="text-align:center;">No data available</td></tr>
		  <?php } ?> 
          </tbody>
          </table><br><br>
          <?php if(isset($data['first_page']) && $data['first_page']=='0'){ ?>
            <div class="row">
              <div class="col-md-2">
              
              </div>
              <div class="col-md-2">
              </div>
              <div class="col-md-2">
                <label>Start Page : </label>
                <input type="text" class="form-control" id="start_page" name="start_page" value="" required>
              </div>
			  <div class="col-md-2">
                <label><br></label>
                <input type="submit" class="form-control btn btn-success" name="submit" onclick="update_created_issue_order('<?php echo $issue_name;?>')" value="Save">
              </div>
            </div> 
		  <?php } ?>			
        </div>
      </div>
    <!-- /.box -->
  </section>  
</div>

<!-- DataTables -->
<script src="<?= base_url() ?>public/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?= base_url() ?>public/plugins/datatables/dataTables.bootstrap.min.js"></script>
<script>
  $(function () {
    $("#example1").DataTable();
  });
</script> 
<script>
  $("#invoices").addClass('active');
</script>
<style>
.removeRow
{
 background-color: #FF0000;
    color:#FFFFFF;
}
</style>
<script src="https://code.jquery.com/jquery-1.12.4.js"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
<script>
$( function() {
$( ".sortable" ).sortable();
$( ".sortable" ).disableSelection();
} );
</script>
<script>
function update_created_issue_order(issue_name)
{
	// alert(issue_name);
	var list_of_issue_array_ids = new Array();
	var page_numbers_array = new Array();
	var tbody = document.getElementById('tbody_'+issue_name);
	if(tbody.length != 0)
	{
		var table_data = tbody.querySelectorAll('.list_issue_id');
		if(table_data.length > 0)
		{
			for(var i=0; i<table_data.length; i++)
			{
				var get_ids = table_data[i].innerText;
				list_of_issue_array_ids.push(get_ids);
				var no_of_pages_data  = tbody.querySelectorAll('.no_of_pages');
				if(no_of_pages_data.length > 0)
				{
					var get_page_num = no_of_pages_data[i].innerText;
					page_numbers_array.push(get_page_num);
				}
				
			}
		}
		if(document.getElementById('start_page').value == '')
		{
			alert('Please enter the start page value');
			return false;
		}
		
		if((document.getElementById('start_page').value % 2) == 0  )
		{
			alert('Please enter the odd number only');
			return false;
		}

		var start_page = document.getElementById('start_page').value;
		// alert(list_of_issue_array_ids);
		// alert(page_numbers_array);
		
		$.ajax({
			type: "POST",
			url:  "<?php echo base_url('admin/issues/updateissue')?>",
			data: {list_of_issue_array_ids:list_of_issue_array_ids, issue_name:issue_name, page_numbers_array:page_numbers_array, start_page:start_page},
			cache: false,       
			success: function(data)
			{
				// alert(data);
				if(data != '')
				{
					location.reload();
					alert('Issue Saved Successfully!!!');
				}
				else
				{
					return false;
				}
			}
		});
		
	}
}
</script>
