<!-- DataTables -->
<link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables/dataTables.bootstrap4.css"> 
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Main content -->
    <section class="content">
      <!-- For Messages -->
      <?php $this->load->view('admin/includes/_messages.php') ?>
      <div class="card card-default">
        <div class="card-header">
          <div class="d-inline-block">
              <h3 class="card-title"> <i class="fa fa-list"></i>
              &nbsp; List of all issues processing </h3>
          </div>
        </div>
        <?php if($error = $this->session->flashdata('msg')){ ?>
            <div class="alert alert-success" id="msg">
                 <a href="#" class="close" data-dismiss="alert">&times;</a>
                 <strong>Success!</strong> <?php echo  $error; ?>
            </div>
        <?php } ?>
        <div class="card-body table-responsive">
          <table id="example1" class="table table-bordered table-striped ">
          <thead>
          <tr>
            <th>S.NO.</th>
            <th>ISSUE YEAR</th>
            <th>ISSUE MONTH</th>
  		      <th>ISSUE NAME</th>
            <th>SEND TO PRODUCTION</th>
            <th>STATUS</th>
        
          </tr>
          </thead>
          <tbody>
            <?php $s_no = 1; foreach($issue_detail as $data): //print_r($data); ?>
            <tr>
              <td><?php echo $s_no;?></td>
              <td><?= $data['issue_year']; ?></td>
              <td><?= $data['issue_month']; ?></td>
              <td><a href="<?= base_url('admin/issues/vieweachissue/'.$data['issue_name']); ?>" ><?= $data['issue_name']; ?></a></td>
              <td>
                <?php
                  if ($data['sent_to_prod'] != '0000-00-00') { ?>
                    <a href="#" class="btn-edit" data-id="<?= $data['issue_name']?>" data-status="<?= $data['status']?>" data-senttoprod="<?= $data['sent_to_prod']?>"><strong><?= date('d-m-Y',strtotime($data['sent_to_prod']))?></strong></a>
                  <?php }
                  else{ ?>
				   <?php if ($data['order_by'] != '0' && $data['first_page'] != '0' && $data['last_page'] != '0' && $data['doi_number']) { ?>
                    <a href="#" class="btn-edit" data-id="<?= $data['issue_name']?>" data-status="<?= $data['status']?>" data-senttoprod="<?= $data['sent_to_prod']?>"><strong>Send</strong></a>
				   <?php } else { ?>
				   <strong>Send</strong>
				   <?php } ?>
                 <?php }
                ?>
                </td>
                <td><?= $data['status']; ?></td>
                
  		      </tr>
            <?php $s_no++; endforeach; ?>
          </tbody>
          </table>
            </div>    
        </div>
      </div>
    <!-- /.box -->
  </section>  
</div>
<!-- Modal Edit Product-->
    <form action="updateSentToProd" method="post">
        <div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Send to Production</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
             
                <div class="form-group">
                    <label>Date</label>
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">

                    <input type="hidden" class="id" name="id" value="<?= $data['issue_name']; ?>" >
                    <input type="hidden" class="" name="status">
                    <input type="hidden" class="" name="issue_name" value="">
                    <input type="date" class="form-control senttoprod" name="senttoprod" value="" >
                </div>             
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Update</button>
            </div>
            </div>
        </div>
        </div>
    </form>
    <!-- End Modal Edit Product-->
    <!-- Modal Edit Product-->
    <form action="updatePublish" method="post">
        <div class="modal fade" id="editModal1" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Publish</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
             
                <div class="form-group">
                    <label>Date</label>
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">

                    <input type="hidden" class="id" name="id" value="" >
                    <input type="hidden" class="" name="status">
                    <input type="hidden" class="" name="issue_name" value="<?= $data['issue_name']; ?>">
                    <input type="date" class="form-control publish" name="publish" value="" >
                </div>             
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Update</button>
            </div>
            </div>
        </div>
        </div>
    </form>
    <!-- End Modal Edit Product-->
<!-- DataTables -->
<script src="<?= base_url() ?>public/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?= base_url() ?>public/plugins/datatables/dataTables.bootstrap.min.js"></script>
<script>
  $(function () {
    $("#example1").DataTable();
  });
</script> 
<script>
  $("#invoices").addClass('active');
</script>
<style>
.removeRow
{
 background-color: #FF0000;
    color:#FFFFFF;
}
</style>
<script src="/js/jquery.min.js"></script>
<script src="/js/bootstrap.bundle.min.js"></script>
<script>
    $(document).ready(function(){
 
        // get Edit Product
        $('.btn-edit').on('click',function(){
            // get data from button edit
            const id = $(this).data('id');
            const senttoprod = $(this).data('senttoprod');
            const status = $(this).data('status');
            const duedate = $(this).data('duedate');
            // Set data to Form Edit
            $('.id').val(id);
            $('.senttoprod').val(senttoprod);
            $('.status').val(status);
            $('.duedate').val(duedate);
            
            // Call Modal Edit
            $('#editModal').modal('show');
            
        });
        $('.btn-edit1').on('click',function(){
            // get data from button edit
            const id = $(this).data('id');
            const publish = $(this).data('publish');
            const status = $(this).data('status');
            const duedate = $(this).data('duedate');
            // Set data to Form Edit
            $('.id').val(id);
            $('.publish').val(publish);
            $('.status').val(status);
            $('.duedate').val(duedate);
            
            // Call Modal Edit
            $('#editModal1').modal('show');
            
        });
 
        // get Delete Product
        $('.btn-delete').on('click',function(){
            // get data from button edit
            const id = $(this).data('id');
            // Set data to Form Edit
            $('.productID').val(id);
            // Call Modal Edit
            $('#deleteModal').modal('show');
        });
         
    });
</script>
