<!-- DataTables -->
<link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables/dataTables.bootstrap4.css"> 
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Main content -->
    <section class="content">
      <!-- For Messages -->
      <?php $this->load->view('admin/includes/_messages.php') ?>
      <div class="card card-default">
        <div class="card-header">
          <div class="d-inline-block">
              <h3 class="card-title"> <i class="fa fa-list"></i>
              &nbsp; List of all issues </h3>
          </div>
        </div>
        <?php if($error = $this->session->flashdata('msg')){ ?>
            <div class="alert alert-success" id="msg">
                 <a href="#" class="close" data-dismiss="alert">&times;</a>
                 <strong>Success!</strong> <?php echo  $error; ?>
            </div>
        <?php } ?>
        <div class="card-body table-responsive">
          <table id="example1" class="table table-bordered table-striped ">
          <thead>
          <tr>
			<th>S.NO.</th>
            <th>CUSTOMER REC. DATE</th>
            <th>JOURNAL NAME</th>
			<th>ARTICLE NO</th>
			<th>DOI</th>
			<th>PDF PAGES</th>
			<th>SUPPL. PDF PAGES</th>
			<th>NO. OF FIGURES</th>
			<th>PUBLISHED ONLINE DATE</th>			
			
  		  <!--  <th>MS PAGES</th>
            <th>DUE&nbsp; DATE</th>
            <th>MPS DUE</th>
            <th>1ST PROOF SHIP</th>
            <th>COMP1 RECEIVED</th>
            <th>ISSUE</th> -->
			
            
            <th>ACTION</th>
            <th>ORDER</th>            
          </tr>
          </thead>
		  <form action="<?php echo base_url('admin/issues/createissue')?>" method="post" onsubmit="doit()">
          <tbody>
            <?php $s_no = 1; foreach($article_detail as $data): ?>
            <tr>
              <td><?php echo $s_no;?></td>
              <td><?= date('d-m-Y',strtotime($data['uploaded_date'])); ?></td>
              <td><?= $data['journal_name']; ?></td>
			  <td><?= $data['article_no']; ?></td>
			  <td><?= $data['doi']; ?></td>
			  <td><?= $data['pdf_pages']; ?></td>
			  <td><?= $data['supp_pdf_pages']; ?></td>
			  <td><?= $data['nof']; ?></td>
			  <td><?= $data['uploaded_date']; ?></td>
			  
			  
			  
        <?php /*      <td><?= $data['ms_word']; ?></td>
              <?php
              $today = date('Y-m-d');
              $due_date = date('d-m-Y',strtotime($data['due_date']));
              if ($data['due_date'] < $today) {
                ?><td style="background:red; color: white; font-weight: 700;"><?= $due_date; ?></td>
              <?php }
              else{ ?>
                <td><?= $due_date; ?></td>
              <?php
              }
              ?>
              <td>
                <?php
                  if ($data['mpsDueDate'] != '0000-00-00') { ?>
                    <?= date('d-m-Y',strtotime($data['mpsDueDate']))?></a>
                  <?php }
                  else{ ?>
                    Not assigned</a>
                 <?php }
                ?>
              </td>
              <td><?= date('d-m-Y',strtotime($data['sent_to_gp'])); ?></td>
              <td><?= date('d-m-Y',strtotime($data['approved_date'])); ?></td>
              <td><?= $data['issue']; ?></td> */?>
             
              <td style="text-align: center;">
                <input type="checkbox" class="form-control selected_checkboxes" name='selected[]' value="<?= $data['article_no']; ?>" />
              </td>
              <td><input type="number" class="order_by" name="order_by[]" value=""></td>
  		      </tr>
            <?php $s_no++; endforeach; ?>
			<?php
			  if(count($article_detail) > 0)
			  {
				  $articles_count = count($article_detail);
			  }
			  else
			  {
				  $articles_count = '';
			  }
			?>
			<?php if(empty($articles_count)) {?>
			<tr><td colspan="12" style="text-align:center;">No data available</td></tr>
			<?php } ?>
            <input type="hidden" name="first_page" value="" class="form-control">
            <input type="hidden" name="submit" value="Submit" class="btn btn-success">
          </tbody>
          </table><br><br>
          
		  
		  
            <div class="row" style="visibility:<?php echo (!empty($articles_count)?'visible':'hidden');?>;">
              <div class="col-md-2">
			   <?php $year = date("Y"); ;?>
                <label>Issue Year:</label>
                <select name="issue_year" class="form-control">
                <option value="2025" <?php echo (strcmp($year,'2025')==0)?"selected":""?>>2025</option>
				<option value="2024" <?php echo (strcmp($year,'2024')==0)?"selected":""?>>2024</option>
				<option value="2023" <?php echo (strcmp($year,'2023')==0)?"selected":""?>>2023</option>
				<option value="2022" <?php echo (strcmp($year,'2022')==0)?"selected":""?>>2022</option>
				<option value="2021" <?php echo (strcmp($year,'2021')==0)?"selected":""?>>2021</option>
				<option value="2020" <?php echo (strcmp($year,'2020')==0)?"selected":""?>>2020</option>
				<option value="2019" <?php echo (strcmp($year,'2019')==0)?"selected":""?>>2019</option>
				</select>
              </div>
              <div class="col-md-2">
			  <?php $month = date("F", strtotime('m'));?>
                <label>Issue Month:</label>
                <select name="issue_month" class="form-control">
                <option value="January" <?php echo (strcmp($month,'January')==0)?"selected":""?>>January</option>
				<option value="February" <?php echo (strcmp($month,'February')==0)?"selected":""?>>February</option>
				<option value="March" <?php echo (strcmp($month,'March')==0)?"selected":""?>>March</option>
				<option value="April" <?php echo (strcmp($month,'April')==0)?"selected":""?>>April</option>
				<option value="May" <?php echo (strcmp($month,'May')==0)?"selected":""?>>May</option>
				<option value="June" <?php echo (strcmp($month,'June')==0)?"selected":""?>>June</option>
				<option value="July" <?php echo (strcmp($month,'July')==0)?"selected":""?>>July</option>
				<option value="August" <?php echo (strcmp($month,'August')==0)?"selected":""?>>August</option>
				<option value="September" <?php echo (strcmp($month,'September')==0)?"selected":""?>>September</option>
				<option value="October" <?php echo (strcmp($month,'October')==0)?"selected":""?>>October</option>
				<option value="November" <?php echo (strcmp($month,'November')==0)?"selected":""?>>November</option>
				<option value="December" <?php echo (strcmp($month,'December')==0)?"selected":""?>>December</option>
                </select>
              </div>
			  <div class="col-md-2">
                <label>Volume : </label>
                <input type="text" class="form-control" name="volume" id="volume_number" required>
              </div>
              <div class="col-md-2">
                <label>Issue : </label>
                <input type="text" class="form-control" name="issue" id="issue_number" onkeyup="duplicate_issue_check()" required>
              </div>
              <div class="col-md-2">
                <label>Create Issue</label>
                <input type="submit" class="form-control btn btn-success" name="submit" value="Submit">
              </div>
            </div>    
         </form>
        </div>
		<p style="text-align:center;padding-top:2%;"><button type="button" class="btn btn-success" onclick="window.history.back()" >Back</button></p>
      </div>
    <!-- /.box -->
  </section>  
</div>

<!-- DataTables -->
<script src="<?= base_url() ?>public/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?= base_url() ?>public/plugins/datatables/dataTables.bootstrap.min.js"></script>
<script>
$(function () 
{
	$("#example1").DataTable();
});
</script> 
<script>
  $("#invoices").addClass('active');

function doit() 
{
	var selected_checkboxes = new Array(); 
	var markedCheckbox = document.querySelectorAll('.selected_checkboxes:checked');
	$(markedCheckbox).each(function() { 
	selected_checkboxes.push($(this).val()); 
	});
	
	if(selected_checkboxes == '')
	{
		alert('Please select atleast one checkbox');
		return false;
	}
}
function duplicate_issue_check()
{
	var volume = $('#volume_number').val();
	var issue = $('#issue_number').val();
	
	var issue_name = 'CBM_'+issue+'_'+volume;
	$.ajax({
		type: "POST",
		url:  "<?php echo base_url('admin/issues/check_duplicate_issues')?>",
		data: {issue_name:issue_name},
		cache: false,       
		success: function(data)
		{
			data = data.replace('\t','');
			data = data.trim();
			if(data == 1)
			{
				alert('Issue name duplicated, Please check');
				// $('#issue_number').val('');
				return false;
			}
		}
	});
}  

</script>
<style>
.removeRow
{
 background-color: #FF0000;
    color:#FFFFFF;
}
</style>

