<!-- DataTables -->
<link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables/dataTables.bootstrap4.css"> 
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Main content -->
    <section class="content">
      <!-- For Messages -->
      <?php $this->load->view('admin/includes/_messages.php') ?>
      <div class="card card-default">
        <div class="card-header">
          <div class="d-inline-block">
              <h3 class="card-title"> <i class="fa fa-list"></i>
              &nbsp; List of all issues </h3>
          </div>
        </div>
        <?php if($error = $this->session->flashdata('msg')){ ?>
            <div class="alert alert-success" id="msg">
                 <a href="#" class="close" data-dismiss="alert">&times;</a>
                 <strong>Success!</strong> <?php echo  $error; ?>
            </div>
        <?php } ?>
        <div class="card-body table-responsive">
          <table id="example1" class="table table-bordered table-striped ">
          <thead>
          <tr>
           <th>S.NO.</th>
            <th>CUSTOMER REC. DATE</th>
            <th>JOURNAL NAME</th>
  		    <th>MS PAGES</th>
            <th>DUE&nbsp; DATE</th>
            <th>MPS DUE</th>
            <th>1ST PROOF SHIP</th>
            <th>COMP1 RECEIVED</th>
            <th>ISSUE</th>
            <th>ARTICLE NO.</th>
            <th>ACTION</th>
            <th>ORDER</th>            
          </tr>
          </thead>
		  <form action="<?php echo base_url('admin/issues/createissue')?>" method="post" onsubmit="doit()">
          <tbody>
            <?php $s_no = 1; foreach($article_detail as $data): ?>
            <tr>
              <td><?php echo $s_no;?></td>
              <td><?= date('d-m-Y',strtotime($data['uploaded_date'])); ?></td>
              <td><?= $data['journal_name']; ?></td>
              <td><?= $data['ms_word']; ?></td>
              <?php
              $today = date('Y-m-d');
              $due_date = date('d-m-Y',strtotime($data['due_date']));
              if ($data['due_date'] < $today) {
                ?><td style="background:red; color: white; font-weight: 700;"><?= $due_date; ?></td>
              <?php }
              else{ ?>
                <td><?= $due_date; ?></td>
              <?php
              }
              ?>
              <td>
                <?php
                  if ($data['mpsDueDate'] != '0000-00-00') { ?>
                    <?= date('d-m-Y',strtotime($data['mpsDueDate']))?></a>
                  <?php }
                  else{ ?>
                    Not assigned</a>
                 <?php }
                ?>
              </td>
              <td><?= date('d-m-Y',strtotime($data['sent_to_gp'])); ?></td>
              <td><?= date('d-m-Y',strtotime($data['approved_date'])); ?></td>
              <td><?= $data['issue']; ?></td>
              <td><?= $data['article_no']; ?></td>
              <td style="text-align: center;">
                <input type="checkbox" class="form-control selected_checkboxes" name='selected[]' value="<?= $data['article_no']; ?>" />
              </td>
              <td><input type="number" name="order_by[]" value=""></td>
  		      </tr>
            <?php $s_no++; endforeach; ?>
			<?php
			  if(count($article_detail) > 0)
			  {
				  $articles_count = count($article_detail);
			  }
			  else
			  {
				  $articles_count = '';
			  }
			?>
			<?php if(empty($articles_count)) {?>
			<tr><td colspan="12" style="text-align:center;">No data available</td></tr>
			<?php } ?>
            <input type="hidden" name="first_page" value="" class="form-control">
            <input type="hidden" name="submit" value="Submit" class="btn btn-success">
          </tbody>
          </table><br><br>
          
		  
		  
            <div class="row" style="visibility:<?php echo (!empty($articles_count)?'visible':'hidden');?>;">
              <div class="col-md-2">
                <label>Issue Year: </label>
                <select name="issue_year" class="form-control">
                  <?php
                      for ($i = 0; $i <= 3; ++$i){
                          $time = strtotime(sprintf('-%d years', $i));
                          $value = date('Y', $time);
                          echo '<option value="'.$value.'" ';
                          if((isset($_GET['year']))&&($value==$_GET['year']))echo 'selected';// Check if form submitted or not. select the year if yes
                          echo '>'.$value.'</option>';
                      }
                  ?>
                </select>
              </div>
              <div class="col-md-2">
                <label>Issue Month: </label>
				 
                <select name="issue_month" class="form-control">
                  <?php
                      for ($i = 1; $i <= 12; ++$i){
                          $time = strtotime(sprintf('+%d months', $i));
                          $label = date('F ', $time);
                          $value = date('F', $time);
						 // prasanna addded 03-01-2022		
						 $month = date("F", strtotime('m'));
						
                          echo '<option value="'.$value.'" ';
                          if((isset($month))&&($value==$month))echo 'selected';// Check if form submitted or not. select the month if yes
                          echo '>'.$label.'</option>';
                      }
                  ?>
                </select>
              </div>
			  <div class="col-md-2">
                <label>Volume : </label>
                <input type="text" class="form-control" name="volume" required>
              </div>
              <div class="col-md-2">
                <label>Issue : </label>
                <input type="text" class="form-control" name="issue" required>
              </div>
              <div class="col-md-2">
                <label>Create Issue</label>
                <input type="submit" class="form-control btn btn-success" name="submit" value="Submit">
              </div>
            </div>    
         </form>
        </div>
		<p style="text-align:center;padding-top:2%;"><button type="button" class="btn btn-success" onclick="window.history.back()" >Back</button></p>
      </div>
    <!-- /.box -->
  </section>  
</div>

<!-- DataTables -->
<script src="<?= base_url() ?>public/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?= base_url() ?>public/plugins/datatables/dataTables.bootstrap.min.js"></script>
<script>
$(function () 
{
	$("#example1").DataTable();
});
</script> 
<script>
  $("#invoices").addClass('active');

function doit() 
{
	var selected_checkboxes = new Array(); 
	var markedCheckbox = document.querySelectorAll('.selected_checkboxes:checked');
	$(markedCheckbox).each(function() { 
	selected_checkboxes.push($(this).val()); 
	});
	
	if(selected_checkboxes == '')
	{
		alert('Please select atleast one checkbox');
		return false;
	}
}  

</script>
<style>
.removeRow
{
 background-color: #FF0000;
    color:#FFFFFF;
}
</style>

