<!-- bootstrap datepicker -->
<link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datepicker/datepicker3.css">

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Main content -->
    <section class="content">
      <div class="card card-default">
        <div class="card-header">
          <div class="d-inline-block">
              <h3 class="card-title"> <i class="fa fa-pencil"></i>
              &nbsp; Edit Issue</h3>
          </div>
          <div class="d-inline-block float-right">
            <a href="<?= base_url('admin/issues'); ?>" class="btn btn-success"><i class="fa fa-list"></i> Issue List</a>
            <a href="<?= base_url('admin/issues/add'); ?>" class="btn btn-success"><i class="fa fa-plus"></i> Add new Issue</a>
          </div>
        </div>
        <div class="card-body">
   
           <!-- For Messages -->
            <?php $this->load->view('admin/includes/_messages.php') ?>

            <?php echo form_open( base_url('admin/issues/edit/'.$issue_detail['id'])); ?>
            <div class="row">
              <div class="col-md-3">
                <div class="card">
                  <div class="card-header with-border">
                    <h3 class="card-title">Issue Details</h3>
                  </div>
                  <!-- /.card-header -->
                  <!-- form start -->
                  <div class="card-body">
                      <div class="form-group">
                        <label for="issue_name" class="control-label">Issue Name</label>
                        <input type="text" name="issue_name" class="form-control" id="issue_name" value="<?= $issue_detail['issue_name']; ?>" placeholder="" required>
                      </div>
                      
                      <div class="form-group">
                        <label for="issue_id" class="control-label">Issue ID</label>
                        <input type="text" name="issue_id" class="form-control" id="issue_id" value="<?= $issue_detail['issue_id']; ?>" placeholder="" required>
                      </div>

                      <div class="form-group">
                        <label for="journal_name" class="control-label">Journal Name</label>
                        <input type="text" name="journal_name" class="form-control" id="journal_name" value="<?= $issue_detail['journal_name']; ?>" placeholder="" required>
                      </div>
                      <div class="form-group">
                        <label for="article_no" class="control-label">Article No.</label>
                        <input type="text" name="article_no" class="form-control" id="article_no" value="<?= $issue_detail['article_no']; ?>" placeholder="" >
                      </div>
                      <div class="form-group">
                        <label for="no_of_pages" class="control-label">No. Of. Pages</label>
                        <input type="number" name="no_of_pages" class="form-control" id="no_of_pages" value="<?= $issue_detail['no_of_pages']; ?>" placeholder="" >
                      </div>
                    </div>
                    <!-- /.card-body -->
                </div>
              </div>

              <div class="col-md-3">
                <div class="card">
                  <div class="card-header with-border">
                    <h3 class="card-title">---</h3>
                  </div>
                  <!-- /.card-header -->
                  <!-- form start -->
                  <div class="card-body">
                      <div class="form-group">
                        <label for="start_page" class="control-label">Start Page</label>
                        <input type="number" name="start_page" class="form-control" id="start_page" value="<?= $issue_detail['start_page']; ?>" placeholder="" >
                      </div>
                      <div class="form-group">
                        <label for="end_page" class="control-label">End Page</label>
                        <input type="number" name="end_page" class="form-control" id="end_page" value="<?= $issue_detail['end_page']; ?>" placeholder="" >
                      </div>
                      
                      <div class="form-group">
                        <label for="order_by" class="control-label">Order By</label>
                        <input type="text" name="order_by" class="form-control" id="order_by" value="<?= $issue_detail['order_by']; ?>" placeholder="" >
                      </div>

                      <div class="form-group">
                        <label for="created_by" class="control-label">Created By</label>
                        <input type="text" name="created_by" class="form-control" id="created_by" value="<?= $issue_detail['created_by']; ?>" placeholder="" >
                      </div>
                      <div class="form-group">
                        <label for="is_delete" class="control-label">Delete</label>
                        <select class="form-control" name="is_delete" value="<?= $issue_detail['is_delete']; ?>">
                            <option value="InActive">InActive</option>
                            <option value="Active">Active</option>
                          </select>
                      </div>
                      
                  </div>
                </div>
              </div>

              <div class="col-md-12">
                <div class="card">
                  <div class="card-body">
                    <input type="submit" name="submit" value="Save Issue" class="btn btn-primary pull-right">
                  </div>
                </div>
              </div>
            </div>
            <?php echo form_close(); ?>
        </div>  
      </div>
    </section>
  </div>


 <!-- bootstrap datepicker -->
  <script src="<?= base_url() ?>public/plugins/datepicker/bootstrap-datepicker.js"></script>
  <script>
    $('.datepicker').datepicker({
      autoclose: true
    });
  </script>

  <script type="text/javascript">
    $(function(){

      //---------------------------------------------------------------
      $('#customer').change(function(e){
        var id = $('#customer').val();
        var post_data = {
          '<?php echo $this->security->get_csrf_token_name(); ?>' : '<?php echo $this->security->get_csrf_hash(); ?>'
        };
        $.ajax({
          type: 'POST',
          url: '<?= base_url("admin/invoices/customer_detail/"); ?>'+id,
          data: post_data,
          success: function(response){
            var data = JSON.parse(response);
            console.log(data.id);
            $('#firstname').val(data.firstname);
            $('#lastname').val(data.lastname);
            $('#email').val(data.email);
            $('#mobile_no').val(data.mobile_no);
          }
        });

      });

      //---------------------------------------------------------------
      $(document).on("click change paste keyup", ".calcEvent", function() {
        calculate_total();
      });

      var max_field = 10;
      var add_button = $('.add_button');
      var wrapper = $('.field_wrapper');
      var html_fields = '<tr class="item"><td> <a href="javascript:void(0);" class="remove_button btn btn-sm btn-danger" title="Remove field"><i class="fa fa-minus"></i></a> </td> <td> <div class="form-group"> <input type="text" name="product_description[]" class="form-control calcEvent" id="product_description" placeholder="Description"> </div> </td> <td> <div class="form-group"> <input type="text" name="quantity[]" value="1" class="form-control calcEvent quantity" id="quantity" placeholder=""> </div> </td> <td> <div class="form-group"> <input type="text" name="price[]" class="form-control calcEvent price" id="price" placeholder=""> </div> </td> <td> <div class="form-group"> <input type="text" name="tax[]" class="form-control calcEvent tax" id="tax" placeholder=""> </div> </td> <td> <input type="hidden" name="total[]" class="form-control calcEvent item_total" placeholder=""><strong class="item_total">0.00</strong> </td> </tr>';

      var x = 1; // 

      $(add_button).click(function(){
        calculate_total();
        if(x < max_field){
          x++;
          $(wrapper).append(html_fields);
        }

      });

      $(wrapper).on('click change keyup', '.remove_button', function(e){
        e.preventDefault();
        $(this).closest('tr').remove(); //Remove field html
        x--; //Decrement field counter
        calculate_total();
        console.log('remove');
      });

    });


     //---------------------------------------------------------------
     function calculate_total(){

        var sub_total    = 0;
        var total       = 0;
        var amountDue   = 0;
        var total_tax    = 0;

        $('tr.item').each(function(){
          var quantity = parseFloat($(this).find(".quantity").val());
          var price = parseFloat($(this).find(".price").val());
          var item_tax = $(this).find(".tax").val();

          var item_total = parseFloat(quantity * price) > 0 ? parseFloat(quantity * price) : 0 ;
          sub_total += parseFloat(price * quantity) > 0 ? parseFloat(price * quantity) : 0;
          total_tax += parseFloat(price * quantity * item_tax/100) > 0 ? parseFloat(price * quantity * item_tax/100) : 0;

          $(this).find('.item_total').text( item_total.toFixed(2) );
          $(this).find('.item_total').val( item_total.toFixed(2) ); 
        });

        var discount    = parseFloat($("[name='discount']").val()) > 0 ? parseFloat($("[name='discount']").val()) : 0;
        total += parseFloat(sub_total + total_tax - discount);

        $( '.sub_total' ).text( sub_total.toFixed(2) );
        $( '.sub_total' ).val( sub_total.toFixed(2) ); // for hidden field

        $( '.total_tax' ).text( total_tax.toFixed(2) );
        $( '.total_tax' ).val( total_tax.toFixed(2) ); // for hidden field

        $( '#grand_total' ).text( total.toFixed(2) );
        $( '.grand_total' ).val( total.toFixed(2) ); // for hidden field

     }


  </script>
  <script>
    $('#invoices').addClass('active');
  </script>

 