<?php defined('BASEPATH') OR exit('No direct script access allowed');

	class Articles extends MY_Controller {

		public function __construct(){

			parent::__construct();
			auth_check(); // check login auth
			$this->rbac->check_module_access();

			$this->load->model('admin/articles_model', 'articles_model');
			$this->load->model('admin/Activity_model', 'activity_model');
		}

		//---------------------------------------------------
		// // Get All Articles
		public function index(){

			$data['article_detail'] = $this->articles_model->get_all_Articles();

			$this->load->view('admin/includes/_header');
        	$this->load->view('admin/articles/articles-list', $data);
        	$this->load->view('admin/includes/_footer');
		}
		//---------------------------------------------------
		// Get View Article
		public function view($id=0){

			// $this->rbac->check_operation_access(); // check opration permission

			//$data['article_detail'] = $this->articles_model->get_article_by_id($id);
			$data['article_detail'] = $this->articles_model->get_view_article_by_id_($id);

			$this->load->view('admin/includes/_header');
        	$this->load->view('admin/articles/article-view', $data);
        	$this->load->view('admin/includes/_footer');
		}
		public function new(){

			$data['article_detail'] = $this->articles_model->get_all_new();

			$this->load->view('admin/includes/_header');
        	$this->load->view('admin/articles/new-list', $data);
        	$this->load->view('admin/includes/_footer');
		}
		// // Get All Articles in Copyediting
		public function copyediting(){

			$data['article_detail'] = $this->articles_model->get_all_copyediting();

			$this->load->view('admin/includes/_header');
        	$this->load->view('admin/articles/copyediting-list', $data);
        	$this->load->view('admin/includes/_footer');
		}
		// // Get All Articles in CE proof for author approval
		public function ceproof(){

			$data['article_detail'] = $this->articles_model->get_all_ceproof();

			$this->load->view('admin/includes/_header');
        	$this->load->view('admin/articles/ce-proof-for-author-approval', $data);
        	$this->load->view('admin/includes/_footer');
		}

		public function galleryproof(){

			$data['article_detail'] = $this->articles_model->get_all_galleryproof();

			$this->load->view('admin/includes/_header');
        	$this->load->view('admin/articles/gallery-proof', $data);
        	$this->load->view('admin/includes/_footer');
		}

		public function authorrevises(){

			$data['article_detail'] = $this->articles_model->get_all_authorrevises();

			$this->load->view('admin/includes/_header');
        	$this->load->view('admin/articles/author-revises', $data);
        	$this->load->view('admin/includes/_footer');
		}
		public function authorreviseslist($article_no="0"){
			// $this->rbac->check_operation_access(); // check opration permission
			$data['article_detail'] = $this->articles_model->get_all_authorreviseslist($article_no);

			$this->load->view('admin/includes/_header');
        	$this->load->view('admin/articles/author-revises-list', $data);
        	$this->load->view('admin/includes/_footer');
		}
		public function perevises(){

			$data['article_detail'] = $this->articles_model->get_all_perevises();

			$this->load->view('admin/includes/_header');
        	$this->load->view('admin/articles/pe-revises', $data);
        	$this->load->view('admin/includes/_footer');
		}
		public function pereviseslist($article_no="0"){
			// $this->rbac->check_operation_access(); // check opration permission
			$data['article_detail'] = $this->articles_model->get_all_pereviseslist($article_no);

			$this->load->view('admin/includes/_header');
        	$this->load->view('admin/articles/pe-revises-list', $data);
        	$this->load->view('admin/includes/_footer');
		}
		
		public function aoparticles(){

			$data['article_detail'] = $this->articles_model->get_all_aoparticles();

			$this->load->view('admin/includes/_header');
        	$this->load->view('admin/articles/aoparticles', $data);
        	$this->load->view('admin/includes/_footer');
		}

		public function published(){

			$data['article_detail'] = $this->articles_model->get_all_published();

			$this->load->view('admin/includes/_header');
        	$this->load->view('admin/articles/published', $data);
        	$this->load->view('admin/includes/_footer');
		}


		// //---------------------------------------------------
		// // Add New Articles
		public function add()
		{
			// $this->rbac->check_operation_access(); // check opration permission

			if($this->input->post('submit')){
				
					$data['article_data'] = array(

						'id' => "",
						'journal_name' => $this->input->post('journal_name'),
						'received_date' => $this->input->post('received_date'),
						'article_no' => $this->input->post('article_no'),
						'no_chap' => $this->input->post('no_chap'),
						'math' => $this->input->post('math'),
						'tables' => $this->input->post('tables'),
						'figures' => $this->input->post('figures'),
						'book_color' => $this->input->post('book_color'),
						'ms_word' => $this->input->post('ms_word'),
						'article_type' => $this->input->post('article_type'),
						'cleaned_pages' => $this->input->post('cleaned_pages'),
						'not1' => $this->input->post('not1'),
						'nof' => $this->input->post('nof'),
						'hdate1' => $this->input->post('hdate1'),
						'hdate2' => $this->input->post('hdate2'),
						'hdate3' => $this->input->post('hdate3'),
						'doi' => $this->input->post('doi'),
						'color_figure' => $this->input->post('color_figure'),
						'copy_edit' => $this->input->post('copy_edit'),
						'jour_issue' => $this->input->post('jour_issue'),
						'issue' => $this->input->post('issue'),
						'due_date' => $this->input->post('due_date'),
						'pdmr_date' => $this->input->post('pdmr_date'),
						'job_type' => $this->input->post('job_type'),
						'work_type' => $this->input->post('work_type'),
						'sin_dou_column' => $this->input->post('sin_dou_column'),
						'jour_job_type' => $this->input->post('jour_job_type'),
						'jour_process' => $this->input->post('jour_process'),
						'book_job_type' => $this->input->post('book_job_type'),
						'book_process' => $this->input->post('book_process'),
						'free_book' => $this->input->post('free_book'),
						'depart' => $this->input->post('depart'),
						'category' => $this->input->post('category'),
						'loginDelay' => $this->input->post('loginDelay'),
						'journal_id' => $this->input->post('journal_id'),
						'is_delete' => $this->input->post('is_delete'),
						'figure_query' => $this->input->post('figure_query'),
						'query' => $this->input->post('query'),
						'supp' => $this->input->post('supp'),
						'aop_free' => $this->input->post('aop_free'),
						'openaccess' => $this->input->post('openaccess'),
						'fresh_query' => $this->input->post('fresh_query'),
						'lang' => $this->input->post('lang'),
						'mpsDueDate' => $this->input->post('mpsDueDate'),
						'article_duedate' => $this->input->post('article_duedate'),
						'created_date' => $this->input->post('created_date'),
						'current_stage' => $this->input->post('current_stage'),
						'graphics_details' => $this->input->post('graphics_details'),
						'graphics_req_stage' => $this->input->post('graphics_req_stage'),
						'status' => $this->input->post('status'),
						'priority' => $this->input->post('priority'),
						'sent_to_ce' => $this->input->post('sent_to_ce'),
						'sent_to_author' => $this->input->post('sent_to_author'),
						'sent_to_gp' => $this->input->post('sent_to_gp'),
						'sent_pdf_to_author' => $this->input->post('sent_pdf_to_author'),
						'sent_pdf_to_pe' => $this->input->post('sent_pdf_to_pe'),
						'approved_date' => $this->input->post('approved_date'),
						'uploaded_date' => $this->input->post('uploaded_date'),
						'remarks_article' => $this->input->post('remarks_article'),
						'remarks_ce' => $this->input->post('remarks_ce'),
						'remarks_author' => $this->input->post('remarks_author'),
						'remarks_typesetting' => $this->input->post('remarks_typesetting'),
						'remarks_pe' => $this->input->post('remarks_pe'),
						'remarks_production' => $this->input->post('remarks_production'),
						'pdf_pages' => $this->input->post('pdf_pages'),
						'proof_pages' => $this->input->post('proof_pages'),
						'ce_proof_pages' => $this->input->post('ce_proof_pages'),
						'exp_from_ce' => $this->input->post('exp_from_ce'),
						'received_from_ce' => $this->input->post('received_from_ce'),
						'exp_from_author' => $this->input->post('exp_from_author'),
						'received_from_author' => $this->input->post('received_from_author'),
						'received_from_pe' => $this->input->post('received_from_pe'),

					);

					$article_data = $this->security->xss_clean($data['article_data']);

					$result = $this->articles_model->add_article($article_data);
					if($result){
						// Activity Log 
						$this->activity_model->add_log(7);

						$this->session->set_flashdata('success', 'Article has been Added Successfully!');
						redirect(base_url('admin/articles/new'));
					}
				}	
			
			else{
				$data['title'] = 'Article';
				$data['journal'] = $this->articles_model->get_all_Articles();

				$this->load->view('admin/includes/_header');
        		$this->load->view('admin/articles/add-article', $data);
        		$this->load->view('admin/includes/_footer');
			}
			
		}

		

		
		//---------------------------------------------------
		// Edit Article
		public function edit($id=0){

		//	$this->rbac->check_operation_access(); // check opration permission

			if($this->input->post('submit')){

					$data['article_data'] = array(

						'id' => $this->input->post('id'),
						'journal_name' => $this->input->post('journal_name'),
						'received_date' => $this->input->post('received_date'),
						'article_no' => $this->input->post('article_no'),
						'no_chap' => $this->input->post('no_chap'),
						'math' => $this->input->post('math'),
						'tables' => $this->input->post('tables'),
						'figures' => $this->input->post('figures'),
						'book_color' => $this->input->post('book_color'),
						'ms_word' => $this->input->post('ms_word'),
						'article_type' => $this->input->post('article_type'),
						'copyedit_level' => $this->input->post('copyedit_level'),
						'cleaned_pages' => $this->input->post('cleaned_pages'),
						'not1' => $this->input->post('not1'),
						'nof' => $this->input->post('nof'),
						'hdate1' => $this->input->post('hdate1'),
						'hdate2' => $this->input->post('hdate2'),
						'hdate3' => $this->input->post('hdate3'),
						'doi' => $this->input->post('doi'),
						'color_figure' => $this->input->post('color_figure'),
						'copy_edit' => $this->input->post('copy_edit'),
						'jour_issue' => $this->input->post('jour_issue'),
						'issue' => $this->input->post('issue'),
						'due_date' => $this->input->post('due_date'),
						'pdmr_date' => $this->input->post('pdmr_date'),
						'job_type' => $this->input->post('job_type'),
						'work_type' => $this->input->post('work_type'),
						'sin_dou_column' => $this->input->post('sin_dou_column'),
						'jour_job_type' => $this->input->post('jour_job_type'),
						'jour_process' => $this->input->post('jour_process'),
						'book_job_type' => $this->input->post('book_job_type'),
						'book_process' => $this->input->post('book_process'),
						'free_book' => $this->input->post('free_book'),
						'depart' => $this->input->post('depart'),
						'category' => $this->input->post('category'),
						'loginDelay' => $this->input->post('loginDelay'),
						'journal_id' => $this->input->post('journal_id'),
						'is_delete' => $this->input->post('is_delete'),
						'figure_query' => $this->input->post('figure_query'),
						'query' => $this->input->post('query'),
						'supp' => $this->input->post('supp'),
						'aop_free' => $this->input->post('aop_free'),
						'openaccess' => $this->input->post('openaccess'),
						'fresh_query' => $this->input->post('fresh_query'),
						'lang' => $this->input->post('lang'),
						'mpsDueDate' => $this->input->post('mpsDueDate'),
						'article_duedate' => $this->input->post('article_duedate'),
						'created_date' => $this->input->post('created_date'),
						'current_stage' => $this->input->post('current_stage'),
						'graphics_details' => $this->input->post('graphics_details'),
						'graphics_req_stage' => $this->input->post('graphics_req_stage'),
						'status' => $this->input->post('status'),
						'priority' => $this->input->post('priority'),
						'sent_to_ce' => $this->input->post('sent_to_ce'),
						'sent_to_author' => $this->input->post('sent_to_author'),
						'sent_to_gp' => $this->input->post('sent_to_gp'),
						'sent_pdf_to_author' => $this->input->post('sent_pdf_to_author'),
						'sent_pdf_to_pe' => $this->input->post('sent_pdf_to_pe'),
						'approved_date' => $this->input->post('approved_date'),
						'uploaded_date' => $this->input->post('uploaded_date'),
						'remarks_article' => $this->input->post('remarks_article'),
						'remarks_ce' => $this->input->post('remarks_ce'),
						'remarks_author' => $this->input->post('remarks_author'),
						'remarks_typesetting' => $this->input->post('remarks_typesetting'),
						'remarks_pe' => $this->input->post('remarks_pe'),
						'remarks_production' => $this->input->post('remarks_production'),
						'pdf_pages' => $this->input->post('pdf_pages'),
						'proof_pages' => $this->input->post('proof_pages'),
						'ce_proof_pages' => $this->input->post('ce_proof_pages'),
						'exp_from_ce' => $this->input->post('exp_from_ce'),
						'received_from_ce' => $this->input->post('received_from_ce'),
						'exp_from_author' => $this->input->post('exp_from_author'),
						'received_from_author' => $this->input->post('received_from_author'),
						'received_from_pe' => $this->input->post('received_from_pe'),
					);

					$article_data = $this->security->xss_clean($data['article_data']);

					$result = $this->articles_model->update_article($article_data, $id);
					print_r($data['article_data']);
					if($result){
						// Activity Log 
						$this->activity_model->add_log(7);

						$this->session->set_flashdata('success', 'Article has been Updated Successfully!');
						// redirect(base_url('admin/articles'));
						//////////// Code updated prasanna 05-01-2022
						if(!empty($this->uri->segment(5)))
						{
							$segment = $this->uri->segment(5);
							redirect(base_url('admin/articles/'.$segment));
						}
						else
						{
							redirect(base_url('admin/articles'));
						}
					}
				}	
			
			else{
				$data['title'] = 'Article';
				$data['article_detail'] = $this->articles_model->get_article_by_id($id);
				$data['journal'] = $this->articles_model->get_all_Articles();

				$this->load->view('admin/includes/_header');
        		$this->load->view('admin/articles/edit-article', $data);
        		$this->load->view('admin/includes/_footer');
			}
		}

		//---------------------------------------------------
		// Delete Articles
		public function delete($id){

			// $this->rbac->check_operation_access(); // check opration permission
			
			$data = $this->articles_model->get_article_by_id($id);
			$article_no = $data['article_no'];
			
			$result1 = $this->db->delete('author_revises', array('article_no' => $article_no));
			$result2 = $this->db->delete('pe_revises', array('article_no' => $article_no));
			
			$result = $this->db->delete('journal', array('id' => $id));
			if($result){
				// Activity Log 
				$this->activity_model->add_log(9);
				$this->session->set_flashdata('success', 'Record has been deleted Successfully!');
				redirect(base_url('admin/articles'));
			}
		}
		public function updateSentToCe()
	    {
	    	// $this->rbac->check_operation_access(); // check opration permission
	    	$model = new articles_model();
	        $id = $this->input->post('id');
	        $due_date = $this->input->post('senttoce');
	        

	        $count3WD = 0;
			$temp = strtotime($due_date); 
			while($count3WD<3){
			    $next1WD = strtotime('+1 weekday', $temp);
			    $next1WDDate = date('Y-m-d', $next1WD);
			    if(!in_array($next1WDDate, array('2022-02-30'))){
			        $count3WD++;
			    }
			    $temp = $next1WD;
			}

			$new_due_date = date("Y-m-d", $temp);




			$current_stage =  "Copyediting"; 
			$status = "WIP";			
	        $data = array(
	            'sent_to_ce'        => $this->input->post('senttoce'),
	            'exp_from_ce'	=> $new_due_date,
	            'current_stage' => $current_stage,
	            'status' => $status,
	        );
	        $model->update_data($data, $id);
	        redirect(base_url('admin/articles/new'));
		}

		public function updateSentToAuthor()
	    {
	    //	$this->rbac->check_operation_access(); // check opration permission
	    	$model = new articles_model();
	        $id = $this->input->post('id');
	        $due_date = $this->input->post('senttoauthor');
			$received_from_ce = $this->input->post('received_from_ce');
			$remarks_ce = $this->input->post('remarks_ce');
			$ce_proof_pages = $this->input->post('ce_proof_pages');
			$copy_edit = $this->input->post('copy_edit');
			$copyedit_level = $this->input->post('copyedit_level');
	        

	        $count3WD = 0;
			$temp = strtotime($due_date); 
			while($count3WD<3){
			    $next1WD = strtotime('+1 weekday', $temp);
			    $next1WDDate = date('Y-m-d', $next1WD);
			    if(!in_array($next1WDDate, array('2022-02-30'))){
			        $count3WD++;
			    }
			    $temp = $next1WD;
			}

			$new_due_date = date("Y-m-d", $temp);




			$current_stage =  "CE proof for author approval"; 
			$status = "Author";			
	        $data = array(
	            'sent_to_author'        => $this->input->post('senttoauthor'),
	            'exp_from_author'	=> $new_due_date, 
				'received_from_ce'	=> $received_from_ce,
				'remarks_ce'	=> $remarks_ce,
				'ce_proof_pages'	=> $ce_proof_pages,
				'copy_edit'	=> $copy_edit,
				'copyedit_level'	=> $copyedit_level,
	            'current_stage' => $current_stage,
	            'status' => $status,
	        );
	        
	        $model->update_data($data, $id);

	        redirect(base_url('admin/articles/copyediting'));
		}
		public function updateReceivedfromAuthor()
	    {
	    //	$this->rbac->check_operation_access(); // check opration permission
	    	$model = new articles_model();
	        $id = $this->input->post('id');
	        $due_date = $this->input->post('receivedfromauthor');
	        $remarks_author = $this->input->post('remarks_author');

	        $count3WD = 0;
			$temp = strtotime($due_date); 
			while($count3WD<3){
			    $next1WD = strtotime('+1 weekday', $temp);
			    $next1WDDate = date('Y-m-d', $next1WD);
			    if(!in_array($next1WDDate, array('2022-02-30'))){
			        $count3WD++;
			    }
			    $temp = $next1WD;
			}

			$new_due_date = date("Y-m-d", $temp);
			$current_stage =  "Gallery Proof"; 
			$status = "Production";			
	        $data = array(
				'remarks_author'  => $remarks_author,
	            'sent_to_gp'        => $this->input->post('receivedfromauthor'),
	            'exp_from_gp'	=> $new_due_date,
	            'current_stage' => $current_stage,
	            'status' => $status,
	        );
	        $model->update_data($data, $id);
	        redirect(base_url('admin/articles/ceproof'));
		}
		public function updateSentPdfToAuthor()
	    {
	    //	$this->rbac->check_operation_access(); // check opration permission
	    	$model = new articles_model();
	        $id = $this->input->post('id');
	        $due_date = $this->input->post('sentpdftoauthor');
			$pdf_pages = $this->input->post('pdf_pages');
			$supp_pdf_pages = $this->input->post('supp_pdf_pages');
			$remarks_typesetting = $this->input->post('remarks_typesetting');
	        

	        $count3WD = 0;
			$temp = strtotime($due_date); 
			while($count3WD<3){
			    $next1WD = strtotime('+1 weekday', $temp);
			    $next1WDDate = date('Y-m-d', $next1WD);
			    if(!in_array($next1WDDate, array('2022-02-30'))){
			        $count3WD++;
			    }
			    $temp = $next1WD;
			}

			$new_due_date = date("Y-m-d", $temp);
			$current_stage =  "Author Revises"; 
			$status = "Author";			
	        $data = array(
				'pdf_pages'	=> $pdf_pages,
				'supp_pdf_pages'	=> $supp_pdf_pages,
				'remarks_typesetting'	=> $remarks_typesetting,
	            'sent_pdf_to_author'        => $this->input->post('sentpdftoauthor'),
	            'exp_from_author'	=> $new_due_date,
	            'current_stage' => $current_stage,
	            'status' => $status,
	        );
	        $data1 = array(
	        	'article_no' => $this->input->post('articleno'),
	        	'sent_pdf_to_author' => $this->input->post('sentpdftoauthor'),
	        	'exp_from_author' => $new_due_date,
	        	'current_stage' => $current_stage,
	        	'status' => $status
	        );
	        $model->insert_arevises($data1);
	        $model->update_data($data, $id);
	        redirect(base_url('admin/articles/galleryproof'));
		}
		public function updateSentPdfToAuthorrevise()
	    {
	    //	$this->rbac->check_operation_access(); // check opration permission
	    	$model = new articles_model();
	        $id = $this->input->post('id');
	        $due_date = $this->input->post('sentpdftoauthor');
	        

	        $count3WD = 0;
			$temp = strtotime($due_date); 
			while($count3WD<3){
			    $next1WD = strtotime('+1 weekday', $temp);
			    $next1WDDate = date('Y-m-d', $next1WD);
			    if(!in_array($next1WDDate, array('2022-02-30'))){
			        $count3WD++;
			    }
			    $temp = $next1WD;
			}

			$new_due_date = date("Y-m-d", $temp);




			$current_stage =  "Author Revises"; 
			$status = "Author";			
	        $data = array(
	        	'article_no' => $this->input->post('article_no'),
	            'sent_pdf_to_author'        => $this->input->post('sentpdftoauthor'),
	            'exp_from_author'	=> $new_due_date,
	            'current_stage' => $current_stage,
	            'status' => $status,
	        );
	        $model->update_revises_data($data, $id);
	        $model->update_data($data, $id);
	        redirect(base_url('admin/articles/authorrevises'));
		}
		public function updateRecPdfFromAuthor()
	    {
	    //	$this->rbac->check_operation_access(); // check opration permission
	    	$model = new articles_model();
	        $id = $this->input->post('id');
	        $rec_from_author = $this->input->post('pdfsenttoauthor');
			$author_revises_remarks = $this->input->post('author_revises_remarks');
			//$due_date = $this->input->post('pdfsenttoauthor');
	        //$aa = ['2020-01-01'];

	        $count3WD = 0;
			$temp = strtotime($rec_from_author); 
			while($count3WD<3){
			    $next1WD = strtotime('+1 weekday', $temp);
			    $next1WDDate = date('Y-m-d', $next1WD);
			    if(!in_array($next1WDDate, array('2022-02-30'))){
			        $count3WD++;
			    }
			    $temp = $next1WD;
			}

			$new_due_date = date("Y-m-d", $temp);




			$current_stage =  "Author Revises"; 
			$status = "Production";			
	        $data = array(
	        	'article_no' => $this->input->post('article_no'),
	            'received_from_author'        => $this->input->post('recpdffromauthor'),
	            'current_stage' => $current_stage,
	            'status' => $status,
				'author_revises_remarks' => $author_revises_remarks,
	        );
	        $model->update_revises_rec($data, $rec_from_author);
	        $model->update_data($data, $id);
	        redirect(base_url('admin/articles/authorrevises'));
		}


		public function updateSentPdfToPe()
	    {
	    //	$this->rbac->check_operation_access(); // check opration permission
	    	$model = new articles_model();
	        $id = $this->input->post('id');
	        $due_date = $this->input->post('sentpdftope');
	        

	        $count3WD = 0;
			$temp = strtotime($due_date); 
			while($count3WD<3){
			    $next1WD = strtotime('+1 weekday', $temp);
			    $next1WDDate = date('Y-m-d', $next1WD);
			    if(!in_array($next1WDDate, array('2022-02-30'))){
			        $count3WD++;
			    }
			    $temp = $next1WD;
			}

			$new_due_date = date("Y-m-d", $temp);
			$current_stage =  "PE Revises"; 
			$status = "PE";			
	        $data = array(
	            'sent_pdf_to_pe'        => $this->input->post('sentpdftope'),
	            'exp_from_pe'	=> $new_due_date,
	            'current_stage' => $current_stage,
	            'status' => $status,
	        );
	        $data1 = array(
	        	'article_no' => $this->input->post('article_no'),
	        	'sent_pdf_to_pe' => $this->input->post('sentpdftope'),
	        	'exp_from_pe' => $new_due_date,
	        	'current_stage' => $current_stage,
	        	'status' => $status
	        );
	        $model->insert_perevises($data1);

	        $model->update_data($data, $id);
	        redirect(base_url('admin/articles/authorrevises'));
		}
		public function updateSentPdfToPerevises()
	    {
	    //	$this->rbac->check_operation_access(); // check opration permission
	    	$model = new articles_model();
	        $id = $this->input->post('id');
	        $due_date = $this->input->post('sentpdftope');
	        

	        $count3WD = 0;
			$temp = strtotime($due_date); 
			while($count3WD<3){
			    $next1WD = strtotime('+1 weekday', $temp);
			    $next1WDDate = date('Y-m-d', $next1WD);
			    if(!in_array($next1WDDate, array('2022-02-30'))){
			        $count3WD++;
			    }
			    $temp = $next1WD;
			}

			$new_due_date = date("Y-m-d", $temp);




			$current_stage =  "PE Revises"; 
			$status = "PE";			
	        $data = array(
	        	'article_no' => $this->input->post('article_no'),
	            'sent_pdf_to_pe'        => $this->input->post('sentpdftope'),
	            'exp_from_pe'	=> $new_due_date,
	            'current_stage' => $current_stage,
	            'status' => $status,
	        );

	        $model->update_revises_data1($data, $id);
	        $model->update_data($data, $id);
	        redirect(base_url('admin/articles/perevises'));
		}
		public function updateRecPdfToPerevises()
	    {
	    //	$this->rbac->check_operation_access(); // check opration permission
	    	$model = new articles_model();
	        $id = $this->input->post('id');
	        $rec_from_pe = $this->input->post('pdfsenttope');
			$pe_revises_remarks = $this->input->post('pe_revises_remarks');
			
	        $aa = ['2020-01-01'];

	        $count3WD = 0;
			$temp = strtotime($rec_from_pe); 
			while($count3WD<3){
			    $next1WD = strtotime('+1 weekday', $temp);
			    $next1WDDate = date('Y-m-d', $next1WD);
			    if(!in_array($next1WDDate,$aa)){
			        $count3WD++;
			    }
			    $temp = $next1WD;
			}

			$new_due_date = date("Y-m-d", $temp);




			$current_stage =  "PE Revises"; 
			$status = "Production";			
	        $data = array(
	        	'article_no' => $this->input->post('article_no'),
	            'received_from_pe'        => $this->input->post('recpdffrompe'),
	            'current_stage' => $current_stage,
	            'status' => $status,
				'pe_revises_remarks' => $pe_revises_remarks,
	        );
	        $model->update_revises_rec1($data, $rec_from_pe);
	        $model->update_data($data, $id);
	        redirect(base_url('admin/articles/perevises'));
		}

		public function updateapproved()
	    {
	    //	$this->rbac->check_operation_access(); // check opration permission
	    	$model = new articles_model();
	        $id = $this->input->post('id');
	        $due_date = $this->input->post('approved');
	        
			$skip_stage = $this->input->post('skip_stage');
			
			// print_r($skip_stage);exit;
			

	        $count3WD = 0;
			$temp = strtotime($due_date); 
			while($count3WD<2){
			    $next1WD = strtotime('+1 weekday', $temp);
			    $next1WDDate = date('Y-m-d', $next1WD);
			    if(!in_array($next1WDDate, array('2022-02-30'))){
			        $count3WD++;
			    }
			    $temp = $next1WD;
			}

			$new_due_date = date("Y-m-d", $temp);


		
			if($skip_stage == 1)
			{
				$current_stage =  "Published"; 
				$status = "AOP Published";
				
				 $data = array(
	            'uploaded_date' => $new_due_date,
				'exp_upload' => $new_due_date,
	            'current_stage' => $current_stage,
	            'status' => $status,
	        );
				
			}
			else
			{
				$current_stage =  "AOP"; 
				$status = "Production";	
				
				$data = array(
	            'approved_date' => $this->input->post('approved'),
	            'exp_upload'	=> $new_due_date,
	            'current_stage' => $current_stage,
	            'status' => $status,
				);
				
			}
					
	        
	        $model->update_data($data, $id);
	        redirect(base_url('admin/articles/perevises'));
		}

		public function updateuploaded()
	    {
	    //	$this->rbac->check_operation_access(); // check opration permission
	    	$model = new articles_model();
	        $id = $this->input->post('id');
	        $due_date = $this->input->post('uploaded');
	        

	        $count3WD = 0;
			$temp = strtotime($due_date); 
			while($count3WD<3){
			    $next1WD = strtotime('+1 weekday', $temp);
			    $next1WDDate = date('Y-m-d', $next1WD);
			    if(!in_array($next1WDDate, array('2022-02-30'))){
			        $count3WD++;
			    }
			    $temp = $next1WD;
			}

			$new_due_date = date("Y-m-d", $temp);




			$current_stage =  "Published"; 
			$status = "AOP Published";			
	        $data = array(
	            'uploaded_date'        => $this->input->post('uploaded'),
	            'current_stage' => $current_stage,
	            'status' => $status,
	        );
	        $model->update_data($data, $id);
	        redirect(base_url('admin/articles/aoparticles'));
		}
		

		public function updatepriority()
	    {
	    //	$this->rbac->check_operation_access(); // check opration permission
	    	$model = new articles_model();
	        $id = $this->input->post('id');
	        $priority = $this->input->post('priority');
	        			
	        $data = array(
	            'priority'        => $this->input->post('priority'),
	        );
	        $model->update_data($data, $id);
			
			////////////// Mail Triggered Prasanna Start 30-12-2021//////////////
			
			//$from_email = "prasanna@pdmrindia.com"; 
			$to_email = 'webtechnology@pdmrindia.com';
			
			$config = Array(
						   'protocol' => 'smtp',
						   'smtp_host' => 'smtp.gmail.com',
						   'smtp_port' => 587,
						   'smtp_user' => 'pdmrdevelopment@gmail.com',
						   'smtp_pass' => 'Pdmr@2019',
						   'mailtype'  => 'html', 
						   'charset'   => 'iso-8859-1'
					   );
			$this->email->initialize($config);  
		
			$this->load->library('email');
			$this->email->from('pdmrspprt@gmail.com');		  
			$this->email->to($to_email);
			$this->email->subject("Priority Changes"); 
            $message = "
			 <html>
			   <head>
				 <title></title>
			   </head>
			   <body>
				 <p>Dear Developer,</p>
				 
				 <p>In this file priority has been changed, please check.</p>
				 <p>Best Regards,<br/></p>
			   </body>
			 </html>";
			
			$this->email->message($message); 
   			 
         
			if($this->email->send()) 
			{
				echo "1";
			}
			else 
			{
				//show_error($this->email->debugger());
				echo "0";
			}
			
			////////////// Mail Triggered //////////////
			redirect(base_url('admin/articles'));
		}
		public function updatepriority1()
	    {
	    //	$this->rbac->check_operation_access(); // check opration permission
	    	$model = new articles_model();
	        $id = $this->input->post('id');
	        $priority = $this->input->post('priority');
	        			
	        $data = array(
	            'priority'        => $this->input->post('priority'),
	        );
	        $model->update_data($data, $id);
	        redirect(base_url('admin/articles/new'));
		}

	public function checkUser()
   {
      
		$article_no=$this->input->post('article_no');
		
		$this->load->model('admin/articles_model');
		
		$result=$this->articles_model->checkuser($article_no);
		if($result)
		{
		echo  1;	
		}
		else
		{
		echo  0;	
		}
    }	
	
	public function check_DOI()
   {
      
		$doi_no=$this->input->post('doi_number');
		
		$this->load->model('admin/articles_model');
		
		$result=$this->articles_model->checkdoi($doi_no);
		if($result)
		{
		echo  1;	
		}
		else
		{
		echo  0;	
		}
    }

	/////////////////// Prasanna 05-01-2022
		public function copyediting_updatepriority()
	    {
	    //	$this->rbac->check_operation_access(); // check opration permission
	    	$model = new articles_model();
	        $id = $this->input->post('id');
	        $priority = $this->input->post('priority');
	        			
	        $data = array(
	            'priority'        => $this->input->post('priority'),
	        );
	        $model->update_data($data, $id);
	        redirect(base_url('admin/articles/copyediting'));
		}
		public function ceproof_updatepriority()
	    {
	    //	$this->rbac->check_operation_access(); // check opration permission
	    	$model = new articles_model();
	        $id = $this->input->post('id');
	        $priority = $this->input->post('priority');
	        			
	        $data = array(
	            'priority'        => $this->input->post('priority'),
	        );
	        $model->update_data($data, $id);
	        redirect(base_url('admin/articles/ceproof'));
		}
		public function gallery_proof_updatepriority()
	    {
	    //	$this->rbac->check_operation_access(); // check opration permission
	    	$model = new articles_model();
	        $id = $this->input->post('id');
	        $priority = $this->input->post('priority');
	        			
	        $data = array(
	            'priority'        => $this->input->post('priority'),
	        );
	        $model->update_data($data, $id);
	        redirect(base_url('admin/articles/galleryproof'));
		}
		public function author_revises_updatepriority()
	    {
	    //	$this->rbac->check_operation_access(); // check opration permission
	    	$model = new articles_model();
	        $id = $this->input->post('id');
	        $priority = $this->input->post('priority');
	        			
	        $data = array(
	            'priority'        => $this->input->post('priority'),
	        );
	        $model->update_data($data, $id);
	        redirect(base_url('admin/articles/authorrevises'));
		}
		public function pe_revises_updatepriority()
	    {
	    //	$this->rbac->check_operation_access(); // check opration permission
	    	$model = new articles_model();
	        $id = $this->input->post('id');
	        $priority = $this->input->post('priority');
	        			
	        $data = array(
	            'priority'        => $this->input->post('priority'),
	        );
	        $model->update_data($data, $id);
	        redirect(base_url('admin/articles/perevises'));
		}	
   
		public function userrole()
		{
			print_r($this->session->userdata());
		}
		
		public function send_email_copyediting()
	    {
			// print_r($_FILES);exit;
			
	    //	$this->rbac->check_operation_access(); // check opration permission
	    	$model = new articles_model();
	        $id = $this->input->post('id');
			$from = $this->input->post('from_address');
			$to = $this->input->post('to_address');
			$subject = $this->input->post('subject');
			$description = $this->input->post('description');
			
			// print_r($id);exit;
			
		
			$to_name = 'Prasanna';
			$high = 'Hello '.$to_name.'<br/>';
			$email_signature = 'Regards by<br/>CBM Client Management System Team';
			
			$message = '<html><body>';
			$message .= '<p>'.$high.'</p>';
			$message .= '<p>'.$description.'</p>';
			$message .= '<p>'.$email_signature.'</p>';
			$message .= '</body></html>';
			
			$headers  = 'MIME-Version: 1.0' . "\r\n";
			$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
			$headers .=  "From: $from";
			
			mail($to,$subject,$message,$headers);
			
	        redirect(base_url('admin/articles/copyediting'));
		}	
		
		public function notification_email_send()
	    {
			//	$this->rbac->check_operation_access(); // check opration permission
			
			//////////////////// insert table /////////////////
			$cross_training_array = array();
			$files = $_FILES;
			
			// $filesCount = count($_FILES['files']['name']);
			$filesCount = count(array($_FILES['files']['name']));
			
			for($i = 0; $i < $filesCount; $i++)
			{
				$_FILES['file']['name'] = $_FILES['files']['name'][$i];
				$_FILES['file']['type'] = $_FILES['files']['type'][$i];
				$_FILES['file']['tmp_name'] = $_FILES['files']['tmp_name'][$i];
				$_FILES['file']['error'] = $_FILES['files']['error'][$i];
				$_FILES['file']['size']  = $_FILES['files']['size'][$i];

				// File upload configuration
				$uploadPath = './uploads/file/';
				$config['upload_path'] = $uploadPath;
				$config['allowed_types'] = '*';

				// Load and initialize upload library
				$this->load->library('upload', $config);
				$this->upload->initialize($config);

				
				// Upload file to server
				if($this->upload->do_upload('files'))
				{
					// Uploaded file data
					$fileData = $this->upload->data();
					$uploadData[$i]['file_name'] = $fileData['file_name'];
					$cross_training_array['upload_document'] = $fileData['file_name'];
					
				}
			}
			
	    	$model = new articles_model();
	        $id = $this->input->post('id');
			$from = $this->input->post('from_address');
			$to = $this->input->post('to_address');
			$subject = $this->input->post('subject');
			$description = $this->input->post('description');
			$current_segment = $this->input->post('current_segment');
			
			
			$to_name = 'Prasanna';
			$high = 'Hello '.$to_name.'<br/>';
			$email_signature = 'Regards by<br/>CBM Client Management System Team';
			
			$message = '<html><body>';
			$message .= '<p style="word-wrap:pre;">'.$description.'</p>';
			
			if (array_key_exists("upload_document",$cross_training_array))
			{
				// echo "Key exists!";
				$attachment_name = $cross_training_array['upload_document']; 
				$file_path_download = base_url().'uploads/file/'.$attachment_name;	
				$message .= '<p>Please note the following Attached Files on this article: <a href="'.$file_path_download.'" target="_blank">download_link</a></p>';
			}
			else
			{
				// echo "Key does not exist!";
				$attachment_name = '';
				$file_path_download = '';
				$message .='';
			}

			$message .= '</body></html>';
			
			$headers  = 'MIME-Version: 1.0' . "\r\n";
			$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
			$headers .=  "From: $from";
			
			mail($to,$subject,$message,$headers);
			if(!empty($current_segment))
			{
				redirect(base_url('admin/articles/'.$current_segment));
			}
		}	
		public function get_author_revises_remarks()
		{
			// print_r($_POST);exit;
			$article_number = $_POST['remarks_article_no'];
			$select_author_revises_data = $this->db->select('*')
										->from('author_revises')
										->where('article_no',$article_number)
										->get()->result_array();
			$result = '';							
			if(count($select_author_revises_data) > 0)
			{
				$AR = 1;
				
				foreach($select_author_revises_data as $remarks_data)
				{
					$author_revises_remarks = $remarks_data['author_revises_remarks'];
					
					$result .= '<div class="form-group">
					<label style="width:100%;padding-right:5%;">Author Revises '.$AR.'</label>
                    <input style="width:100%;" type="text" class="remarks_author_revises" value="'.$author_revises_remarks.'">
					</div>';
					
					$AR++;
				}
				$result .= '';
			}
			echo $result;
		}
		public function get_pe_revises_remarks()
		{
			// print_r($_POST);exit;
			$article_number = $_POST['remarks_article_no'];
			
			$select_author_revises_data = $this->db->select('*')
										->from('author_revises')
										->where('article_no',$article_number)
										->get()->result_array();
			
			$select_pe_revises_data = $this->db->select('*')
										->from('pe_revises')
										->where('article_no',$article_number)
										->get()->result_array();
										
			$result = '';
			
			$result = '';							
			if(count($select_author_revises_data) > 0)
			{
				$AR = 1;
				
				foreach($select_author_revises_data as $remarks_data)
				{
					$author_revises_remarks = $remarks_data['author_revises_remarks'];
					
					$result .= '<div class="form-group">
					<label style="width:100%;padding-right:5%;">Author Revises '.$AR.'</label>
                    <input style="width:100%;" type="text" class="remarks_author_revises" value="'.$author_revises_remarks.'">
					</div>';
					
					$AR++;
				}
				$result .= '';
			}
			
			if(count($select_pe_revises_data) > 0)
			{
				$PAR = 1;
				
				foreach($select_pe_revises_data as $remarks_data)
				{
					$pe_revises_remarks = $remarks_data['pe_revises_remarks'];
					
					$result .= '<div class="form-group">
					<label style="width:100%;padding-right:5%;">PE Revises '.$PAR.'</label>
                    <input style="width:100%;" type="text" class="remarks_pe_revises" value="'.$pe_revises_remarks.'">
					</div>';
					
					$PAR++;
				}
				$result .= '';
			}
			echo $result;
		}
}
?>	